/*
 * jde, CategoryManager.js, Original coding copied from CategoryMananger.js 22/08/17
 */
'use strict';

var CategoryManager = CategoryManager || {};

CategoryManager =  function () {

    var xhr = XHRManager.getInstance();
    var firstCategoryNumber = -1;
    var currentCategoryNumber = -1;
    var currentCategoryLetter = "";
    var lastCategoryNumber = -1;
    var folderName = ".";
    var whereAbouts = ".";
    var localDebugging = false;    // set this to true and place where needed

    function debug( msg ) {
        if (( localDebugging ) && ( GlobalData.debugging ))
            MainApp.LoggingHandler.logMessage(1, msg);
    }

    function loaded( maxCategoryCount ) {
        if ( typeof maxCategoryCount != "number" )
            return false;
        else {
            firstCategoryNumber = 1;
            lastCategoryNumber = maxCategoryCount;
            currentCategoryNumber = 1;
        }
        //displayCategory();
    }

    var initialisations = function ( foldername, where, noOfCategories ) {
        folderName = foldername;
        whereAbouts = where;
        loaded( noOfCategories );
        MainApp.LoggingHandler.logMessage(1, 'CategoryManager initialised ... ' + noOfCategories + ' categories loaded.', 'color:blue');
    };

    var loadCategoryDetails = function () {
        if (xhr.readyState==4 && xhr.status==200) {
            var sections = JSON.parse( xhr.responseText );
            var bodyElement = document.getElementsByTagName("body");
            var newElement = document.createElement("p");
            var tmpString;
            for (var index = 0; index < sections.length; index ++){
                tmpString = sections[index].text + " " + sections[index].count;
                var textNode = document.createTextNode(tmpString);
                var para = newElement.appendChild(textNode);
                bodyElement[0].appendChild(para);
                debug( tmpString );
            }
        }
    };


    var inrange = function( value, min, max ) {
        debug( 'inrange(' + ' value:' + value + ' min:' + min + ' max:' + max + ')' );
        return ( min <= value) && ( value <= max );
    };

    var displayCategory = function () {
        debug( currentCategoryNumber + ' ' + firstCategoryNumber + ' ' + lastCategoryNumber );
        if ( currentCategoryNumber > lastCategoryNumber )
            currentCategoryNumber = 1;
        if ( currentCategoryNumber < firstCategoryNumber )
            currentCategoryNumber = lastCategoryNumber;
        if ( ! inrange( currentCategoryNumber, firstCategoryNumber, lastCategoryNumber ) )
            currentCategoryNumber = 1;
        debug( "displayCategory Current category number: " + currentCategoryNumber );
        var image = document.getElementById("image");
        if ((image === 'undefined' ) || (image === null)) {
            // create the image id
            var where = document.getElementById( whereAbouts );
            where.innerHTML = ""; // clear out existing contents of where
            var img = document.createElement('img');
            img.setAttribute( 'id', 'image' );
 /*
            img.setAttribute( 'max-height', '560px' );

            img.setAttribute( 'width', '100%' );
*/
            where.appendChild( img );
            // now get the image placeholder
            image = document.getElementById("image");
        }
        var categoryName = "http://localhost/modules/dsa/"+folderName+"/Category"+currentCategoryNumber+".PNG";
        image.setAttribute( "src", categoryName );
    };

    var displayFirstCategory = function () {
        debug( "First category number: " + ' ' + firstCategoryNumber );
        currentCategoryNumber = firstCategoryNumber;
        displayCategory( );
    };

    var displayNextCategory = function () {
        debug( "next category number: " + ' ' + currentCategoryNumber );
        currentCategoryNumber++;
        displayCategory( );
    };

    var displayPreviousCategory = function () {
        debug( "previous category number: " + ' ' + currentCategoryNumber );
        currentCategoryNumber--;
        displayCategory( );
    };

    var displayLastCategory = function () {
        debug( "Last category number: " + ' ' + lastCategoryNumber );
        currentCategoryNumber = lastCategoryNumber;
        displayCategory( );
    };

    var displayCategoryNumber = function ( categoryNumber ) {
        debug( "displayCategoryNumber: " + ' ' + categoryNumber );
        if ( typeof categoryNumber != "number" )
            return false;
        else {
            currentCategoryNumber = categoryNumber;
            PageUpdater.updateElement('SideNavigationHeader', '<p>Results ...</p>', 'add');
            var url = 'dsa/search/categorySearch.php?categoryNumber=' + categoryNumber;
            ContentLoader.loadSnippet(url, 'SideNavigation', 'add');
        }
    };

    var displayCategoryLetter = function ( categoryNumber, categoryLetter ) {
        debug( "displayCategoryLetter: " + categoryNumber + ' ' + categoryLetter );
        if ( typeof categoryLetter != "string" )
            return false;
        else {
            currentCategoryLetter = categoryLetter;
            PageUpdater.updateElement('SideNavigationHeader', '<p>Results ...</p>', 'add');
            var url = 'dsa/search/categorySearch.php?categoryLetter=' + categoryLetter + '&categoryNumber=' + categoryNumber;
            console.log(url);
            ContentLoader.loadSnippet(url, 'mainMiddleContent', 'add');
        }
    };


    return {
        initialise: initialisations,
        display: displayCategoryNumber,
        displayLetter: displayCategoryLetter
    }

} ();
