/*
 * jde, XHRManager.js, Converted from original coding 19/07/17
 */

'use strict';

var XHRManager = XHRManager || {};

XHRManager = function () {
    
    var xhr = null;

    // creates an XMLHttpRequest instance
    function createXMLHttpRequestObject() {
        // xmlHttp will store the reference to the XMLHttpRequest object
        var xmlHttp;
        // try to instantiate the native XMLHttpRequest object
        try {
            // create an XMLHttpRequest object
            xmlHttp = new XMLHttpRequest();
        }
        catch (e) {
            // assume IE6 or older
            try {
                xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
            }
            catch (e) {
            }
        }
        // return the created object or display an error message
        if (!xmlHttp)
            showMessage("Error creating the XMLHttpRequest object.", 'debugArea', true);
        else
            return xmlHttp;
    }

    var initialisations = function () {
        if ( ( xhr == undefined ) || ( xhr == null ) ) {
            xhr = createXMLHttpRequestObject();
            MainApp.LoggingHandler.logMessage(1, "XHRManager initialisations:" + xhr);
        }
        return xhr;
    }
    
    return {
        init : initialisations
    }

}();

