/**
 * Created by jde on 27/07/2017.
 */
// using simple sub-module augmentation
LoggingHandler = (function(){

    var self = {}, debugging, message, colour;

    self.logMessage = function(severity, messageParam, colourParam) {
        if ( debugging ) {
            // if no severity number was possed in, then give the message and warn the user
            if(typeof severity !== 'number'){
                messageParam = severity + " found *** Severity must be numeric"
                severity = 3;
            }
            message = ( typeof messageParam === 'string' ) ? messageParam : message;
            if ( typeof colourParam === 'string' ) {
                colour = colourParam
            } else {
                message += ' (Using default colour details)'; // colour is the default
            }
            if(severity === 3){
                colour = "color:red;font-weight:bold";
            }
            var consoleFunc = (severity === 1) ? 'log' : (severity === 2) ? 'warn' : 'error';
            console[consoleFunc]("%c Severity: " + severity + " ---> " + message, colour);
        }
    };

    self.initialise = function(debuggingParam, messageParam, colourParam) {
        debugging = (typeof debuggingParam === 'boolean' ) ? debuggingParam :  false;
        message = ( typeof messageParam === 'string' ) ? messageParam : "Default LoggingHandler message";
        colour = ( typeof colourParam === 'string' ) ? colourParam : "color:black;font-size:12px";

        self.logMessage(1,
            'LoggingHandler initialised ...',
            'color:blue');

    };

/*
 // register with MainApp via a IIEF
 self.register = (function() {
    MainApp.registerModule(self);
 })();
*/
    return {
       logMessage: self.logMessage,
       initialise: self.initialise
    };
}) ();