/*
 * jde, 28/07/17, renamed startUp() function to initialise() for similarities with other modules
 * jde, 13/07/17, displaySlide() now check to ensure that 'image' exists and if not creates it
 * jde, SlideManager.js, Original coding 10/07/17
 */
'use strict';

var SlideManager = SlideManager || {};

SlideManager =  function () {

    var xhr = XHRManager.getInstance();
    var firstSlideNumber = -1;
    var currentSlideNumber = -1;
    var lastSlideNumber = -1;
    var folderName = ".";
    var whereAbouts = ".";
    var localDebugging = false;    // set this to true and place where needed

    function debug( msg ) {
        if (( localDebugging ) && ( GlobalData.debugging ))
            MainApp.LoggingHandler.logMessage(1, msg);
    }

    function loaded( maxSlideCount ) {
        if ( typeof maxSlideCount != "number" )
            return false;
        else {
            firstSlideNumber = 1;
            lastSlideNumber = maxSlideCount;
            currentSlideNumber = 1;
        }
        //displaySlide();
    }

    var initialisations = function ( foldername, where, noOfSlides ) {
        folderName = foldername;
        whereAbouts = where;
        loaded( noOfSlides );
        MainApp.LoggingHandler.logMessage(1, 'SlideManager initialised ... ' + noOfSlides + ' slides loaded.', 'color:blue');
    };

    var loadSlideDetails = function () {
        if (xhr.readyState==4 && xhr.status==200) {
            var sections = JSON.parse( xhr.responseText );
            var bodyElement = document.getElementsByTagName("body");
            var newElement = document.createElement("p");
            var tmpString;
            for (var index = 0; index < sections.length; index ++){
                tmpString = sections[index].text + " " + sections[index].count;
                var textNode = document.createTextNode(tmpString);
                var para = newElement.appendChild(textNode);
                bodyElement[0].appendChild(para);
                debug( tmpString );
            }
        }
    };


    var inrange = function( value, min, max ) {
        debug( 'inrange(' + ' value:' + value + ' min:' + min + ' max:' + max + ')' );
        return ( min <= value) && ( value <= max );
    };

    var displaySlide = function () {
        debug( currentSlideNumber + ' ' + firstSlideNumber + ' ' + lastSlideNumber );
        if ( currentSlideNumber > lastSlideNumber )
            currentSlideNumber = 1;
        if ( currentSlideNumber < firstSlideNumber )
            currentSlideNumber = lastSlideNumber;
        if ( ! inrange( currentSlideNumber, firstSlideNumber, lastSlideNumber ) )
            currentSlideNumber = 1;
        debug( "displaySlide Current slide number: " + currentSlideNumber );
        var image = document.getElementById("image");
        if ((image === 'undefined' ) || (image === null)) {
            // create the image id
            var where = document.getElementById( whereAbouts );
            where.innerHTML = ""; // clear out existing contents of where
            var img = document.createElement('img');
            img.setAttribute( 'id', 'image' );
 /*
            img.setAttribute( 'max-height', '560px' );

            img.setAttribute( 'width', '100%' );
*/
            where.appendChild( img );
            // now get the image placeholder
            image = document.getElementById("image");
        }
        var slideName = "http://localhost/modules/dsa/"+folderName+"/Slide"+currentSlideNumber+".PNG";
        image.setAttribute( "src", slideName );
    };

    var displayFirstSlide = function () {
        debug( "First slide number: " + ' ' + firstSlideNumber );
        currentSlideNumber = firstSlideNumber;
        displaySlide( );
    };

    var displayNextSlide = function () {
        debug( "next slide number: " + ' ' + currentSlideNumber );
        currentSlideNumber++;
        displaySlide( );
    };

    var displayPreviousSlide = function () {
        debug( "previous slide number: " + ' ' + currentSlideNumber );
        currentSlideNumber--;
        displaySlide( );
    };

    var displayLastSlide = function () {
        debug( "Last slide number: " + ' ' + lastSlideNumber );
        currentSlideNumber = lastSlideNumber;
        displaySlide( );
    };

    var displaySlideNumber = function ( slideNumber ) {
        debug( "displaySlideNumber: " + ' ' + slideNumber );
        if ( typeof slideNumber != "number" )
            return false;
        else {
            currentSlideNumber = slideNumber;
        }
        displaySlide();
    };

    // jde, 13/08/17, changes object css class from closed to open and vice versa, css takes care of hiding and showing object
    var toggle = function ( obj ) {
        //debug( obj )
        var toggleWhat = document.getElementById( obj );
        if ( toggleWhat != null ) {
            var image = toggleWhat.getElementsByTagName( "img" )[0];  // get obj image
            if ( toggleWhat.className == "closed" ) {
                toggleWhat.className = "open";
                if ( image != null ) image.src = "./src/images/minus.gif";  // might not be using an image to show +/-

            } else {
                toggleWhat.className = "closed";
                if ( image != null ) image.src = "./src/images/plus.gif";

            }
        }
    };

    return {
        initialise: initialisations,
        first: displayFirstSlide,
        next: displayNextSlide,
        previous: displayPreviousSlide,
        last: displayLastSlide,
        display: displaySlideNumber,
        toggle: toggle
    }

} ();
