/*
 * jde, 28/07/17, Turned into an Immediately Invoked Function  Expression (IIFE) and assigned its return value
 * (which is a singleton object) to the variable xhr.
 * Usage var xhr = XHRManager.getInstance()
 *
 * jde, XHRManager.js, Converted from original coding 19/07/17. Now uses Module Pattern
 */

'use strict';

var XHRManager = XHRManager || {};

XHRManager = ( function () {

    //private var to hold the xhr
    var xhr = null;

    // creates an XMLHttpRequest instance
    function createXMLHttpRequestObject() {
        // xmlHttp will store the reference to the XMLHttpRequest object
        var xmlHttp;
        // try to instantiate the native XMLHttpRequest object
        try {
            // create an XMLHttpRequest object
            xmlHttp = new XMLHttpRequest();
        }
        catch (e) {
            // assume IE6 or older
            try {
                xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
            }
            catch (e) {
            }
        }
        // return the created object or display an error message
        if (!xmlHttp)
            showMessage("Error creating the XMLHttpRequest object.", 'debugArea', true);
        else
            return xmlHttp;
    }

    function logMessage( severity, message ) {
        if ( ( typeof MainApp == 'undefined' ) ) // && ( MainApp.LoggingHandler == undefined ) && ( MainApp.LoggingHandler.logMessage == undefined ) )
            console.log( message );
        else
            MainApp.LoggingHandler.logMessage(severity, message);

    }

    var initialisations = function () {
        if ( ( xhr == 'undefined' ) || ( xhr == null ) ) {
           xhr = createXMLHttpRequestObject();
           logMessage(1, "XHRManager initialised (xhr:" + xhr + ')');
        }
        return xhr;
    };
    
    return {
        getInstance : initialisations
    }

}) ();

