// singleton class constructor
function Logger() {
	// fields
	this.req = null;

	// methods
	this.errorToXML = errorToXML;
	this.log = log;
}

// map an error to an XML document
function errorToXML(err) {
	var xml = '<?xml version="1.0"?>\n' +
		'<error>\n' +
		'<name>' + err.name + '</name>\n' +
		'<message>'  + err.message + '</message>\n';
	if (err.location) xml += '<location>' + err.location +
		'</location>';
	xml += '</error>';
alert(err);
	return xml;
}

// log method of Logger class
function log(err) {
	// feature sniff
	this.req = createXMLHttpRequestObject();
	// set the method and URI
	this.req.open("POST", "/tmp/AjaxLogger");
	// set the request headers. REFERER will be the top-level
	// URI which may differ from the location of the error if
	// it occurs in an included .js file
	this.req.setRequestHeader('REFERER', location.href);
	this.req.setRequestHeader('content-type', 'text/xml');
	// function to be called when the request is complete
	this.req.onreadystatechange = errorLogged;
	this.req.send(this.errorToXML(err));
	// if the request doesn't complete in 10 seconds,
	// something is up
	this.timeout = window.setTimeout("abortLog();", 10000);
}

// we tried, but if there is a connection error, it is hopeless
function abortLog() {
	logger.req.abort();
	alert("Attempt to log the error timed out.");
}

// called when the state of the request changes
function errorLogged() {
	if (logger.req.readyState != 4) return;
	window.clearTimeout(logger.timeout);
	// request completed
	if (logger.req.status >= 400)
		alert('Attempt to log the error failed.');
}

