<?php
// db.inc.php
require_once("global-constants.inc.php");
require_once("commandLineArguments.inc.php");
require_once("divStuff.inc.php");
require_once "historyClass.php";

function giveUp($mess) {
	header("Location: http://" . $_SERVER["HTTP_HOST"] . dirname($_SERVER["PHP_SELF"]) . "/error.php?mess=$mess");
	exit();
}

function dbConnect() {
	$link = @mysql_connect(HOST, USER, PASSWORD );
	if (!$link) giveUp("could not connect to the database server");
	$select = @mysql_select_db(DBNAME, $link);
	if (!$select) giveUp("could not select the database");
	return $link;
}

// jde, 13/08/17, Added addressInfo
function setUp() {
	dbConnect();
	$userId = isset( $_COOKIE["userid"] ) ? $_COOKIE["userid"] : uniqid("");
	setcookie("userid", $userId, time() + 60 * 60 * 24 * 7 * 30, '/');
//	if (isset($_COOKIE['userid'])) echo "cookie id is set";
	// Get IP address, jde, modified 13/06/16
	$addressInfo = $_SERVER['REMOTE_ADDR'];
	$addressInfo = '' ? "REMOTE_ADDR_UNKNOWN" : $addressInfo;
	$addressInfo = '::1' ? "127.0.0.1" : $addressInfo;
	setcookie("addressInfo", $addressInfo, time() + 60 * 60 * 24 * 7 * 30, '/');
//	if (isset($_COOKIE['addressInfo'])) echo "addressInfo id is set";
	return $userId;
}

function dbQuery($q) {
	$result = mysql_query($q);
	if (!$result) giveUp("a database query ($q) failed");
	return $result;
}

function addOneToCount( $term ) {
	$records = dbQuery("select term from counts where term='$term'");
	if (mysql_num_rows($records) == 0) // term not found, so insert it with new count of 1
		$result = dbQuery("insert into counts values('$term', 1)");
	else
		$result = dbQuery("update counts set count = count + 1 where term='$term'");
	return $result;
}

function getTermValue() {
    return fetchRequestData( 'term1' );
}

function closeDown() {
  // if ( $link ) mysql_close($link);
}

// added dev 29th Nov 07
// modified dev 6th April 09 - now takes care of no value be returned by the $_POST call, assumed to be 'N'
function getCheckBoxValue()
{
    $clean[ 'checkboxValue' ] = fetchRequestData( 'checkboxValue' );
 	$cbxValue = $clean['checkboxValue'];
// 	echo '!' . $cbxValue . '!';
 	if ( $cbxValue == "undefined") $cbxValue = 'N';
 	return trim( $cbxValue );
}

// Added Dev 20th Aug 09
// Routine will now add in the link file, if its found, as part of the xrefs
function formatXrefsAndLinks( $id, $linkFile ) {
	$xref_query = "select term from xrefs where id = $id order by term";
	$xref_records = dbQuery($xref_query);
	$xrefs = "";
	$n = mysql_num_rows($xref_records);
	if ( ($n > 0) || ( $linkFile != "" ) ) { // then we have some xrefs to combine
		$xrefs = "<div class = \"xrefs\"><h2>See also ...</h2>";
// add xrefs if needed
		for ($i = 0; $i < $n; ++$i) {
			$refa = mysql_fetch_array($xref_records);
			$ref = $refa["term"];
			$searchURL = './src/php/glossarySearch.php';
            $xrefs .= createImageHTML( './src/images/link.gif', $ref, 'onClick="ContentLoader.loadSnippet( \'./src/php/glossarySearch.php?checkBoxValue=Y&term1=' . $ref. '\', \'mainMiddleContent\', \'add\' );"' );
		}
// add in the linkfile if there is one
	    if ( $linkFile != "" ) { // then we have a link file, so add it to the returned string
           $xrefs .= createImageHTML( './src/images/link.gif', $linkFile, 'onClick="ContentLoader.loadSnippet( \'' . $linkFile. '\', \'mainMiddleContent\', \'append\' );"' );
	    }
		$xrefs .= "</div>";
	}
	return $xrefs;
}

// jde, 15/08/17, added term so we can check if it points to itself
function format_xrefs($id, $term) {
//	$xref_query = "select term from xrefs where id = $id order by term";
	$xref_query = "select term from topic where term like '%$term%'";
	$xref_records = dbQuery($xref_query);
	$xrefs = "";
	$n = mysql_num_rows($xref_records);
	if ($n > 0) {
		$xrefs = "<div class = \"xrefs\"><h1>See also</h1><ul>";
		for ($i = 0; $i < $n; ++$i) {
			$refa = mysql_fetch_array($xref_records);
			$ref = $refa["term"];
//echo $ref . '!' .$term;
			if ( strtolower($ref) != strtolower($term) )  // ignore pointing back to self
				$xrefs .= "<li><a href=\"src\php\glossarySearch.php?term1=$ref\" title = \"look up $ref\">$ref</a></li>";
		}
		$xrefs .= "</ul></div>";
	}
	return $xrefs;
}

// jde, 06/08/17, removed $term from param list
// Dev 20th Aug modified to make sure we have essentially different terms, added the index from array of returns terms
function formatDefinition($definition_array, $i, $n) {
	$q = ($n > 1) ? " ($i)" : "";
	$returnedTerm = $definition_array["term"];
	$returnedTermPlusCount = $returnedTerm . $i;   // added i so we should always have diferent terms
    $returnString = startClosedDivHTML( $returnedTermPlusCount, $returnedTerm, $definition_array["description"] );
	$xrefs = formatXrefsAndLinks( $definition_array["id"], $definition_array["link"] );
//	$xrefs = format_xrefs( $definition_array["id"], $returnedTerm );
    $returnString .= $xrefs;
    $returnString .= endDivHTML( );
    return $returnString;
}

function makeDefinitions($term, $definition_records, $n) {
	$definition = '<div id="topicSearch"> ' . $term . '<ul>';
	for ($i = 1; $i <= $n; ++$i) {
		$definition .= formatDefinition(mysql_fetch_array($definition_records), $i, $n); // jde, 06/08/17, removed $term from param list
	}
	$definition .= "</ul></div>";
	return $definition;
}

function extractDefinition($term, $definition_records, $user, $history) {
	$n = mysql_num_rows($definition_records);
	if ($n === 0)
		return "<p>No definition for <strong>$term</strong> was found</p>";
	else {
		addOneToCount($term);
		add_to_history($term, $user, $history);
		return makeDefinitions($term, $definition_records, $n);
	}
}

function getDefinition( $term, $user, $history ) {
	$term = mysql_escape_string($term);
	$definition_query = "select id, term, description, link from topic ";
	$definition_query .= ( getCheckBoxValue() == 'Y' ) ? " where term = '$term'" : "where term like '%$term%'";
	return extractDefinition($term, dbQuery($definition_query), $user, $history);
}

function doDefinition($term, $user, $history) {
	//var_dump('doDefinition', $term, $user, $history);
	return $term == "" ? "<p>No data for <strong>$term</strong> was found</p>" : getDefinition( $term, $user, $history );
}

// routine just gets the data from the db without any xref data
function buildTermDescription( $searchTerm, $exactValueWanted, $user, $history ) {
	//var_dump($searchTerm, $exactValueWanted);
  $description = '';

	if ( $searchTerm != "" ) {
	  $searchTextQuery = $exactValueWanted ? "(`term` = '$searchTerm')" : "(`term` like '%$searchTerm%')";
	  // now build the actual query
	  $query = "select id, term, description, link from topic where ";
	  $query .= $searchTextQuery;
//echo $query;

	 $records = dbQuery( $query );
	 $n = mysql_num_rows($records);
//echo "norecs=" . $n;
	 if ($n == 0)
		return "<p>No data for <strong>$searchTerm</strong> was found</p>";
	 else {
		addOneToCount($searchTerm);
		add_to_history($searchTerm, $user, $history);
	    $description = '<div id="topicLink"> ' . $searchTerm;
		$description_array = mysql_fetch_array($records);
	    for ($i = 1; $i <= $n; ++$i) {
		  $returnedslideTitle = $description_array["term"];
//echo $i . ' '. $description_array["id"];
	      $returnedslideTitlePlusCount = $returnedslideTitle . $i;   // added i so we should always have diferent slideTitles
		  $description .= startClosedDivHTML( $returnedslideTitlePlusCount, $returnedslideTitle, $description_array["description"] );
		  $description .= endDivHTML();
		}
	    $description .= "</div>";
     }
  } else {
    $description = '<p>No link data found for ' . $searchTerm . ' </p>';
  }
  return $description;
}

// Modified Dev 22/10/09 Now does a search of the slideText as well as the slideTitle for the searchTerm
// Added Dev 19th Aug 2009
// routine just gets the data from the slides table
function buildSlideDescription( $slideTitle, $exactValueWanted, $user, $history ) {
  $description = '';
  if ( $slideTitle != "" ) {

	  $slideTextQuery = $exactValueWanted ? "(`slidetext` = '$slideTitle')" : "(`slidetext` like '%$slideTitle%')";
      // now build the actual query
	  $query = "select concat(modulePath, '/Slide', s.id, '.PNG') as slidePicture, slideTitle, slidetext ";
	  $query .= "from slideInfo as s, pptInfo as p ";
	  $query .= "where (s.pptId = p.pptId) and $slideTextQuery";
	  $query .= "order by p.pptId, s.id;";
//echo $query;

  	 $slideText_records = dbQuery($query);
//var_dump( $slideText_records );
	 $n = mysql_num_rows($slideText_records);
	 if ($n == 0)
		return "<p>No slide data for <strong>$slideTitle</strong> was found</p>";
	 else {
		addOneToCount($slideTitle);
		add_to_history($slideTitle, $user, $history);
	    $description = '<div id="slideLink"> ' . $slideTitle . '<ul>';
//		$description_array = mysql_fetch_array($slideText_records);
	    for ($i = 1; $i <= $n; ++$i) {
		  $description_array = mysql_fetch_array($slideText_records);
		  $returnedslideTitle = $description_array["slideTitle"];
	      $returnedslideTitlePlusCount = $returnedslideTitle . $i;   // added i so we should always have different slideTitles
		  $linkSlide = $description_array["slidePicture"];
		  $description .= startClosedDivHTML( $returnedslideTitlePlusCount, $returnedslideTitle, $description_array["slidetext"] );
          $description .= createImageHTML( './src/images/link.gif', $returnedslideTitle, 'onClick="ContentLoader.loadSnippet( \'' . $linkSlide. '\', \'mainMiddleContent\', \'add\' );"' );
		  $description .= endDivHTML();
		}
	    $description .= "</ul></div>";
     }
  } else {
    $description = '<p>No link data found for ' . $slideTitle . ' </p>';
  }
  return $description;
}

// Added Dev 19th Aug 2009
// routine just gets the data from the slides db
function fetchSlideCount( $lectureName ) {
  $description = '';
  if ( $lectureName != "" ) {
 	 $dbQuery = "select lectureSlideCount from lectures ";
	 $dbQuery .= " where lectureName like '%" . $lectureName . "%'";
  	 $slideText_records = dbQuery($dbQuery);
	 $n = mysql_num_rows($slideText_records);
	 if ($n == 0)
		$description = "0";
	 else {
	    for ($i = 1; $i <= $n; ++$i) {
		  $description_array = mysql_fetch_array($slideText_records);
		  $description = $description_array["lectureSlideCount"];
		}
     }
  } else {
    $description = "0";
  }
  return $description;
}

// Dev added Dec 30th 2007
function random( $n ) {
  srand( time() );
  return rand( 1, $n );
}

// Dev 6/9/9 Added, original code in the glossary coding
function getRandomQuiz( $asXML ) {
    $aQuery = "SELECT slideTitle, slideText FROM `slides` WHERE slideTitle like '%Quiz%';";
//echo $aQuery;
    $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the record

	$output = "";
	$n = mysql_num_rows($dbRecords);
	if ($n == 0) {
		if ( $asXML )
		{
		   return '<?xml version="1.0"?><response><slideTitle>No slideTitle</slideTitle><slideText>No slideText was found.</slideText></response>';
		}
		else
		{  // assume Text wanted
		   return "<p>No slideText for <strong>random value</strong> was found</p>";
		}
    } else {
    	$recNo = random( $n );  // generate a random number in range 1 -> no of quizzes
	    if ( $asXML ) $output .= '<?xml version="1.0"?><response>';
	    $index = 1;
		while ($row = mysql_fetch_array($dbRecords)) {
		  if ( $index == $recNo ) {
			  if ( $asXML )
			  {
				$output .= "<slideTitle>". $row['slideTitle']."</slideTitle><slideText>". $row['slideText']."</slideText>";
			  }
			  else
			  {
				$output .= $row['slideTitle'].' is '. $row['slideText'].'<br/>';
			  }
		  }
		  $index ++;
		}
	    if ( $asXML ) $output .= "</response>";
	    return $output;
	}
}

// Dev 11/9/9 Added, original code in the glossary coding
function getAllQuizzes( $asXML ) {
    $aQuery = "select slideTitle, slideText from slides where slideText like '%quiz%';";
//echo $aQuery;
    $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the record

	$output = "";
	$n = mysql_num_rows($dbRecords);
	if ($n == 0) {
		if ( $asXML )
		{
		   return '<?xml version="1.0"?><response><slideTitle>No slideTitle</slideTitle><slideText>No slideText was found.</slideText></response>';
		}
		else
		{  // assume Text wanted
		   return "<p>No slideText was found</p>";
		}
    } else {
    	$recNo = random( $n );  // generate a random number in range 1 -> no of quizzes
	    if ( $asXML ) $output .= '<?xml version="1.0"?><response>';
		while ($row = mysql_fetch_array($dbRecords)) {
		  	  if ( $asXML )
			  {
				$output .= "<slideTitle>". $row['slideTitle']."</slideTitle><slideText>". $row['slideText']."</slideText>";
			  }
			  else
			  {
				$output .= $row['slideTitle'].' is '. $row['slideText'].' ';
			  }
		}
	    if ( $asXML ) $output .= "</response>";
	    return $output;
	}
}

// Dev 11/9/9 Added routine to get a quick quiz set
function getQuickQuiz( $questionSet ) {
    $aQuery = "select question, answer, releaseDate from quiz where quizType = 'Q2' and questionSet = '$questionSet' ORDER by questionNo;";
//echo $aQuery;
    $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the record

	$output = '<?xml version="1.0"?><response>';
	$n = mysql_num_rows($dbRecords);
	if ($n == 0) {
	   $output .= '<success>false</success><question>No questions found</question><answer>No answers found</answer>';
	   $output .= '<releaseDate>No release dates found</releaseDate>';
    } else {
	    $output .= '<success>true</success>';
	    $index = 1;
		while ($row = mysql_fetch_array($dbRecords)) {
		  $output .= "<question>". $row['question']."</question><answer>". $row['answer']."</answer>";
	      $output .= '<releaseDate>' . $row['releaseDate'] . '</releaseDate>';
		  $index ++;
		}
	}
	$output .= '</response>';
	return $output;
}

// Dev 13/9/9 Added routine to get a tutorial set
function getTutorial( $questionSet ) {
    $aQuery = "select question, answer, releaseDate from quiz where quizType = 'tut' and questionSet = '$questionSet' ORDER by questionNo;";
//echo $aQuery;
    $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the record

	$output = '<?xml version="1.0"?><response>';
	$n = mysql_num_rows($dbRecords);
	if ($n == 0) {
	   $output .= '<success>false</success><question>No questions found</question><answer>No answers found</answer>';
	   $output .= '<releaseDate>No release dates found</releaseDate>';
    } else {
	    $output .= '<success>true</success>';
	    $index = 1;
		while ($row = mysql_fetch_array($dbRecords)) {
		  $output .= "<question>". $row['question']."</question><answer>". $row['answer']."</answer>";
	      $output .= '<releaseDate>' . $row['releaseDate'] . '</releaseDate>';
		  $index ++;
		}
	}
	$output .= '</response>';
	return $output;
}

// Dev 14/10/09 Routine to create a date string of form dd/mm/yyyy
function dateNow( ) {
	$ty = date("Y");
	$tm = date("m");
	$td = date("d");
	$now = $td.'/'.$tm.'/'.$ty;
	return $now;
}

// Dev added 3/10/09
// Routine returns true if $aDate is before todays date
function beforeToday( $aDate ) {
//echo "Date is $aDate";
// get input date year, month and day number
    $dateStrings = explode( '/', $aDate );
	$iy = $dateStrings[0];
	$im = $dateStrings[1];
	$id = $dateStrings[2];
	$dateNo = mktime( 0, 0, 0, $im, $id, $iy);
//	echo 'checkdate no:' . $dateNo;
// get todays year, month and day number
	$ty = date("Y");
	$tm = date("m");
	$td = date("d");
	$todayNo = mktime(0, 0, 0, $tm, $td, $ty);
//	echo 'today no:' . $todayNo;
	if ( $dateNo < $todayNo ) {
	   $output = true;   // 'before';
	} else {
	  if ( $dateNo == $todayNo ) {
		 $output = true;   // 'before'; we will assume that the same day is before
	  } else {
		 $output = false;  // 'after';
	  }
	}
//echo "output is:$output:";
	return $output;
}

// Dev 03/10/9 Combined previous 2 routines into one
// now requires 2 parameters, the quizType and the questionSet
function getQuiz( $quizType, $questionSet ) {
	$output = '<?xml version="1.0"?><response>';  // start setting up the output value
	if ( ( $quizType != 'Q2' ) && ( $quizType != 'tut' ) ) {
	   $output .= "<success>false</success><question>No questions for $quizType</question><answer>Not found</answer>";
	} else {
	// we have a valid quizType, but first check if we can show the answers
	  $aQuery = "select releaseDate, answerDate from availability where quizType = '$quizType' and questionSet = '$questionSet';";
//echo $aQuery;
      $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the records release date
	  $n = mysql_num_rows($dbRecords);
	  if ($n == 0) {
//echo "No records retrieved";
	     $output .= "<success>false</success><question>No questions for that quiz type</question><answer>Not found</answer>";
      } else {
//echo "$n records retrieved";
        // verify todays date is after the release date
          $canExecuteQuery = true;  // assume we can execute the built query
          $row = mysql_fetch_array($dbRecords);
          $questionCanBeShown = beforeToday( $row['releaseDate'] );
          if ( $questionCanBeShown ) {
             $fields = 'question '; // we can fetch the question, check if can also get the answer
			 $answerCanBeShown = beforeToday( $row['answerDate'] );
//echo "answerCanBeShown:$answerCanBeShown";
			  if ( $answerCanBeShown ) {
				 // we can fetch the answer
				 $fields .= ', answer ';
			  } else {
				 // we can't fetch the answer yet
				 $canFetchQuery = false;
			  }
		  } else {
             // we can't fetch the question yet, so we're done
             $canExecuteQuery = false;
   		  }
// see if we need to get the query
   		  if ( $canExecuteQuery == false ) {
	         $output .= "<success>false</success><question>Questions not available yet!</question><answer>Not available</answer>";
		  } else {
		     $aQuery = "select $fields from quiz where quizType = '$quizType' and questionSet = '$questionSet' ORDER by questionNo;";
//echo $aQuery;

			  $dbRecords = dbQuery( $aQuery ); // execute the sql command to get the quiz records
			  $n = mysql_num_rows($dbRecords);
			  if ($n == 0) {
				 $output .= '<success>false</success><question>No questions found</question><answer>No answers found</answer>';
			  } else {
				$output .= '<success>true</success>';
				$index = 1;
				while ( $row = mysql_fetch_array($dbRecords) ) {
				  $output .= "<question>" . $row['question'] . "</question>";
				  if ( $answerCanBeShown ) {
					 $output .= "<answer>" . $row['answer'] . "</answer>";
				  } else {
					 $output .= "<answer></answer>";
				  }
				  $index ++;
				}
			  }
		  }
	  }
	}
	$output .= '</response>';
	return $output;
}

function buildQuizHTML( $quizType, $quizNo ) {
$html = <<<endOfHTML
  <center>
    <object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
	id="tmp" width="525" height="380"
	codebase="http://fpdownload.macromedia.com/get/flashplayer/current/swflash.cab">
	<param name="movie" value="getQuiz.swf" />
	<param name="quality" value="high" />
	<param name="bgcolor" value="#869ca7" />
	<param name="allowScriptAccess" value="sameDomain" />
	<param name="flashVars" value="quizType=$quizType&quizNo=$quizNo" />
	<embed src="getQuiz.swf" quality="high" bgcolor="#869ca7"
		width="525" height="380" name="tmp" align="middle"
		play="true"
		loop="false"
		quality="high"
		allowScriptAccess="sameDomain"
		type="application/x-shockwave-flash"
		pluginspage="http://www.adobe.com/go/getflashplayer"
		flashVars="quizType=$quizType&quizNo=$quizNo">
	</embed>
   </object>
  </center>
endOfHTML;
return $html;
}


// Added Dev 23rd Oct 2009
// routine searches the tutorial
function buildTutorialDescription( $searchValue, $exactValueWanted ) {
  $description = '';
//  echo "buildTutorialDescription";
  if ( $searchValue != "" ) {
     if ( $exactValueWanted )
  	    $slideText_query = "select quizType, questionSet, question, answer from quiz where question = '$searchValue'";
  	 else
  	    $slideText_query = "select quizType, questionSet, question, answer from quiz where (question like '%$searchValue%') or (answer like '%$searchValue%')";
//echo $slideText_query;
  	 $sText_records = dbQuery($slideText_query);
	 $n = mysql_num_rows( $sText_records );
//echo "$n records returned";
	 if ($n == 0)
		return "<p>No tutorial data for <strong>$searchValue</strong> was found</p>";
	 else {
//		addOneToCount($slideTitle);
//		add_to_history($slideTitle, $user, $history);
	    $description = '<div id="slideLink"> ' . $searchValue . '<ul>';
//		$description_array = mysql_fetch_array($slideText_records);
	    for ($i = 1; $i <= $n; ++$i) {
		  $description_array = mysql_fetch_array($sText_records);
		  $returnedslideTitle = $description_array["question"];
	      $returnedslideTitlePlusCount = $returnedslideTitle . $i;   // added i so we should always have diferent slideTitles
		  $linkSlide = $description_array["answer"];
		  $description .= startClosedDivHTML( $returnedslideTitlePlusCount, $returnedslideTitle, $description_array["answer"] );
		  $description .= endDivHTML();
		}
	    $description .= "</ul></div>";
     }
  } else {
    $description = '<p>No link data found for ' . $searchValue . ' </p>';
  }
  return $description;
}

// jde, 14/08/17, just delegates job to the new History class
function add_to_history( $term, $user, $history ) {
	$userHistory = new History();
	$userHistory->addToHistory( $term, $user, $history );
	unset( $userHistory );
}

function buildCategoryList() {
	$html = "";
	$dbQuery = "select id, name, description from categories ";
	$records = dbQuery($dbQuery);
	$n = mysql_num_rows($records);
	if ($n == 0)
		$html = "0 categories found!";
	else {
		$html .= "<p>No: of categories:" . $n . "</p>";
		for ($i = 1; $i <= $n; ++$i) {
			$description_array = mysql_fetch_array($records);
			$html .= '<button id="but' . $i . '" type="button" onclick="CategoryManager.display(' . $description_array["id"] . ');">' . $description_array["description"] . '</button>';
		}
	}
	return $html;
}

function getCategoryList($categoryNumber) {
	$html = "";
	$dbQuery = "select distinct(letter) from topic where categoryid = '$categoryNumber' order by letter";
//var_dump( $dbQuery );
	$records = dbQuery($dbQuery);
	$n = mysql_num_rows($records);
	if ($n == 0)
		$html = "0 categories found!";
	else {
		$html .= "<p>No: of category letters:" . $n . "</p>";
		for ($i = 1; $i <= $n; ++$i) {
			$description_array = mysql_fetch_array($records);
			$html .= '<button id="but' . $i . '" type="button" onclick="CategoryManager.displayLetter(' . $categoryNumber . ", '" . $description_array["letter"] . "'" . ');">'. $description_array["letter"] .'</button>';
		}
	}
	return $html;
}

/*
 * @Author jde, 22/098/17
 * @returns the
 */
function getLetterList($categoryNumber, $categoryLetter) {
	$html = "";
	$dbQuery = "select id, term, description, link from topic where categoryid = '$categoryNumber' and letter = '$categoryLetter' order by id";
//var_dump( $dbQuery );
	$records = dbQuery($dbQuery);
	$n = mysql_num_rows($records);
	if ($n === 0) {
		return "<p>No definitions for Category:<strong>$categoryNumber</strong>, Letter:<strong>$categoryLetter</strong> found.</p>";
	} else {
		for ($i = 1; $i <= $n; ++$i) {
			$html .= formatDefinition(mysql_fetch_array($records), $i, $n);
		}
	}
	return $html;
}


