/**
 * Created by jde on 27/08/2017.
 */

var LocalStorage = (function (  ) {

    var prefix = "";
    var localStorageSupported = (('localStorage' in window) && window['localStorage']);

    function initialise( appName ) {
        prefix = ( appName != "" ) ? appName + "." : "";
    }

    function isAppKey(key)  {
        if (prefix) {
            return key.indexOf(prefix) === 0;
        }
        return true;
    }

    return {
        init: initialise,
        get: function (dataItemName) {
            if ( ( localStorageSupported ) && ( dataItemName != undefined ) && ( dataItemName != "" ) ) {
                var json = localStorage.getItem( prefix + dataItemName),
                    savedData = JSON.parse(json || "[]");
                return savedData;
            } else {
                return undefined;
            }
        },
        set: function (dataItemName, data) {
            if ( localStorageSupported ) {
                var jsonData = JSON.stringify(data);
                localStorage.setItem(prefix + dataItemName, jsonData);
            }
        },
        remove: function (dataItemName) {
            if (localStorageSupported)
                localStorage.removeItem(prefix + dataItemName);
        },
        removeAll: function() {
            var keys = this.getKeys();
            for (var i in keys) {
                this.remove(keys[i]);
            }
        },
        getKeys: function(filter) {
            var keys = [];
            if (localStorageSupported) {
                for (var key in localStorage) {
                    if (isAppKey(key)) {
                        // Remove the prefix from the key
                        if (prefix) key = key.slice(prefix.length);
                        // Check the filter
                        if (!filter || filter(key)) {
                            keys.push(key);
                        }
                    }
                }
            }
            return keys;
        },
        contains: function(key) {
            var tmp = this.get( key );
            return ( tmp.length == 0 ) ? false : true;
        }

   };
}());

