function getFilenameExtension( filename ) {
  var tmpString = filename;
  var lastDot = tmpString.lastIndexOf( '.' );
  var fileExtension = '';  // assume no file extension to start with
  if ( lastDot > 0 ) fileExtension = tmpString.substr( lastDot, 255 );
  return fileExtension;
}

// filename => path/filenameprefix.extension?parameters
function filenameSplit2( filename ) {
debug('filenameSplit2:'+ filename +': ' + filename.length + ':');
  var parts = new Array();
  for ( var i=0; i<4; i++ ) parts[i] = '';  // initialise the return array to empty strings

  if ( filename.length != 0 ) { // we have a filename to split
     var tmpString = filename;
// 1 lets split the filename into 2, getting the filename part and any parameters given
     var bits = tmpString.split( '?' );
     var noElements =  bits.length;
//     for ( var i=0; i < noElements; i++ ) debug( i + ':' + bits[ i ] );   // show the split bits
     tmpString = bits[0];    // this should be the filename bit
     if ( noElements == 2 ) {
        parts[ 3 ] = bits[ 1 ];   // this is the parameters part
     } else {
       if ( noElements > 2 ) {
          parts[ 3 ] = bits[ 1 ];   // this is the parameters part
       } else {
       // NB all other bits are ignored we take the first bit after the first ? only, so do nothing
       }
     }
// 2 tmpString should now have the filename bit, so lets get any extension
     var bits = tmpString.split( '.' );
     var noElements =  bits.length;
     if ( noElements == 1 ) { // then we don't have any dots
        parts[ 2 ] = '';	// no extension
       tmpString = bits[0];    // this should be the filename bit
     } else {
       tmpString = bits[0];    // this should be the filename bit
       if ( noElements > 0 ) parts[ 2 ] = bits[ noElements - 1 ];   // we take the extension as being the stuff after the last dot
       if ( noElements > 2 ) { // then we have mutiple dots in filename, so we need to put all the parts back together again
	  tmpString = '';
	  for ( var i=0; i<noElements; i++ ) tmpString += bits[ i ] + '.';
       }
     }
//     for ( var i=0; i < noElements; i++ ) debug( i + ':' + bits[ i ] );   // show the split bits
// 3 tmpString should now have the filename bit, so lets get the filenameprefix
     var bits = tmpString.split( '/' );
     var noElements =  bits.length;
     if ( noElements == 1 ) { // then we don't have any slashes
        parts[ 0 ] = '';	// no path
        parts[ 1 ] = tmpString; // just the filenameprefix
     } else {
       tmpString = bits[0];    // this should be the filename bit
       if ( noElements > 0 ) parts[ 1 ] = bits[ noElements - 1 ];   // we take the filenameprefix as being the stuff after the last /
       if ( noElements > 2 ) { // then we have mutiple slashes in filename, so we need to put all the parts back together again
	  tmpString = '';
	  for ( var i=0; i<noElements-1; i++ ) tmpString += bits[ i ] + '/';
       }
       for ( var i=0; i < noElements; i++ ) debug( 'Bits[' + i + ']: ' + bits[ i ]  + ':' );   // show the split bits
// 4 whats left is the path but only if its not empty
       parts[ 0 ] = tmpString;
    }
  }
  debug('Filename is:' + filename + ':' );
  for ( var i=0; i < 4; i++ ) debug( 'Parts[' + i + ']: ' + parts[ i ] + ':' );   // show the returned parts
  return parts;
}

// filename => path/filenameprefix.extension?parameters
function filenameSplit( inputFilename ) {
debug('filenameSplit:'+ inputFilename +': ' +inputFilename.length + ':');
  var parts = new Array();
  var path = '';
  var fileExtension = '';
  var filename = '';
  var parameters = '';
  for ( var i=0; i<4; i++ ) parts[i] = '';  // initialise the return array to empty strings

  if ( inputFilename.length == 0 ) { // we dont have a inputFilename to split
     debug( 'inputFilename length is zero' );
  } else {
     var tmpString = inputFilename;
     var firstQMark = tmpString.indexOf( '?' );
     if ( firstQMark > 0 ) {
        parameters = tmpString.substr( firstQMark + 1, 255 );  // leave the QMark in the return string
        tmpString = tmpString.substr( 0, firstQMark );
     }

     var lastDot = tmpString.lastIndexOf( '.' );
     if ( lastDot > 0 ) {
        fileExtension = tmpString.substr( lastDot, 255 );  // do want the dot
        tmpString = tmpString.substr( 0, lastDot );
     }

     var lastSlash = tmpString.lastIndexOf( '/' );
     if ( lastSlash == -1 ) {
        path = '';  // no path
     } else {
        path = tmpString.substr( 0, lastSlash + 1 );  // put the slash at end back on
     }

     filename = tmpString.substr( lastSlash + 1, 255 );
  } // end of if
  parts[ 0 ] = path;
  parts[ 1 ] = filename;
  parts[ 2 ] = fileExtension;
  parts[ 3 ] = parameters;
  bits = parts[ 1 ].split( '_' );
  parts[ 4 ] = bits[ 1 ];  // this is the file number part eg sl_23 => returns 23
//  for ( var i=0; i < 4; i++ ) debug( 'Parts[' + i + ']: ' + parts[ i ] + ':' );   // show the returned parts
  return parts;
}
