/*
 * jde, MenuLoader.js, Original coding 18/07/17
 */

'use strict';

var MenuLoader = MenuLoader || {};

MenuLoader = function () {

    var menuItems = [];

    function addMenu(pathname, whereAbouts, appendMode) {
        debug('addMenu: (' + pathname + ', ' + whereAbouts + ', ' + appendMode + ')');
        var menuItem = { 'pathname': pathname, 'whereAbouts': whereAbouts, 'addMode': appendMode };
        menuItems.push( menuItem );
        console.log( 'addMenu|menuItems:', menuItems.length );
    }

    // function executed when the state of the request changes
    function handleStateChangeMenu(whereAbouts, preText, postText, appendMode) {
        debug('handleStateChangeMenu:' + whereAbouts + preText + postText + appendMode);
        // continue if the process is completed

        if (xhr.readyState == 4) {
            // continue only if HTTP status is "OK"
            if ((xhr.status >= 200 && xhr.status < 300) || (xhr.status == 304)) {
                try { // now place response in the chosen area of the page if found
                    var where = document.getElementById(whereAbouts);
                    if (where != null) {
                        // build the response
                        var responsTxt = preText + xhr.responseText + postText;
//alert( 'handleStateChangeText responseText:'+ responsTxt + ':' );
                        showMessage(responsTxt, whereAbouts, appendMode);
                        processMenuItems();     // now everything is done we can do the revursive call
                    } else {
                        throw new Error('Error :' + whereAbouts + ' not found on page!');
                    }
                } catch (e) {
                    // display error message
                    showMessage(e.name + "(handleStateChangeText)Error reading the response:" + e.toString(), 'debugArea', true);
                }
            }
            else {
                // display status message
                showMessage("(handleStateChangeText)There was a problem retrieving the data:\n" + xhr.statusText + " (" + xhr.statusCode + ") ", 'debugArea', true);
            }
        }
    }

    function getMenuSnippet(pathname, whereAbouts, appendMode) {
        debug( 'getMenuSnippet:' + pathname +':' +whereAbouts + ':');
        try {
            // initiate server request
            var url = pathname;
            xhr.open("GET", url, true); 				// true => asynchronous call
            xhr.onreadystatechange = function () {
                var preText = '', postText = '';
                handleStateChangeMenu(whereAbouts, preText, postText, appendMode);
            }
            xhr.send(null);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }

    function processMenuItem( item ) {
        if ( item != null ) {
            getMenuSnippet( item.pathname, item.whereAbouts, item.addMode );
            console.log( item.pathname + ' ' + item.whereAbouts );
        }
    }

    function processMenuItems( ) {
        console.log( 'processMenuItems|menuItems:', menuItems.length );
        if ( menuItems.length > 0 ) {
            var item = menuItems.shift();
            console.log( 'processMenuItems|item:', item );
            console.log( 'processMenuItems|menuItems:', menuItems.length );
            processMenuItem( item );
            // processMenuItems();     // Normally recursive call would go here but its asynchronous so do later
        }
    }

    var mainMenu = function( whereAbouts ) {
        xhr = createXMLHttpRequestObject();
        addMenu( './dsa/mainMenu.mnu', whereAbouts, false );
//        addMenu( './dsa/lectures/lectures.sbr', 'SideNavigationShortMenuWrap', false );
        processMenuItems();
    }

    return {
        startup : "Menu start up ok",
        load: mainMenu( 'HeaderNavigationWrap' )
    }

}();
