/**
 * Created by jde on 02/08/2017.
 *         Original coding to perform a search of the backend db table
 */

var Searcher = Searcher || {};

Searcher = ( function() {

    var localDebugging = false;    // set this to true and place where needed

    function debug( msg ) {
        if (( localDebugging ) && ( GlobalData.debugging ))
            MainApp.LoggingHandler.logMessage(1, msg);
    }

    function initialise() {
        MainApp.LoggingHandler.logMessage(1, 'Searcher initialised ... ', 'color:blue');
    }

// jde, copied from original help.js 02/08/17
// Dev 19th Aug 2009 changed name from searchGlossary to doSearch
// now passes a parameter to say which DB to search
    function doSearch(what) {
        var searchTerm = '';   // assume looking for nowt
        var term = document.getElementById('term1');
        if (term != null) searchTerm = term.value;
        debug('doSearch: (Searching ' + what +' for "' + searchTerm + '")');
        console.log('doSearch: (Searching ' + what +' for "' + searchTerm + '")');
        var cboxValue = 'N';   // assume not looking for exact value
        var checkboxValue = document.getElementById('checkboxValue');
        if (checkboxValue != null) {
            if (checkboxValue.checked) cboxValue = 'Y';
        }
        if (searchTerm.length > 0) {
            PageUpdater.updateElement('SideNavigationHeader', '<p>Results ...</p>', 'add');
            if (what == 'glossary')
                var url = './src/php/glossarySearch.php?term1=' + searchTerm + '&checkboxValue=' + cboxValue;
            else // assume slides search
                var url = './src/php/slidesSearch.php?term1=' + searchTerm + '&checkboxValue=' + cboxValue;
            ContentLoader.loadSnippet(url, 'SideNavigation', 'add');
        } else {
            PageUpdater.updateElement('SideNavigation', '<p>Looks like no search term given!</p>', 'append'); // append data message
        }
    }

    return {
        initialise: initialise,
        doSearch: doSearch
    }
}) ();
