(function(globals) {
    globals.GCU = {
        logEnabled: true,
        logTarget: 'console',
        jde: ( window.innerWidth < 809 ) ? 'small' : 'long',

        log: function(message) {
            if (this.log) {
                switch (this.logTarget) {
                    case "console":
                        console.log(message);
                        break;
                    case "alert":
                        alert(message);
                }
            }
        },

        show: function (element, time, callback) {
            if (element._iv) {
                window.clearInterval(element._iv);
            }

            if (typeof element === 'string') {
                element = document.getElementById(element);
            }
            if (element === undefined) {
                return;
            }

            var steps = 10;
            var inc = 1 / steps;
            var opacity = 0;

            element.style.display = "block";

            element._iv = setInterval(function() {
                opacity = opacity + inc;
                if (opacity > 1){
                    opacity = 1;
                    clearInterval(element._iv);
                    if (callback)
                        setTimeout(callback);

                }
                element.style.opacity = opacity;
            }, time / steps);
        },

        hide: function (element, time, keep, callback) {
            if (element._iv) {
                window.clearInterval(element._iv);
            }
            if (typeof element === 'string') {
                element = document.getElementById("element");
            }
            if (element === undefined) {
                return;
            }

            var steps = 10;
            var dec = 1 / steps;
            var opacity = 1;

            element._iv = setInterval(function() {
                opacity = opacity - dec;
                if (opacity < 0){
                    opacity = 0;
                    if (keep !== true)
                        element.style.display = "none";
                    clearInterval(element._iv);
                    if (callback)
                        setTimeout(callback);
                }
                element.style.opacity = opacity;
            }, time / steps);
        },

        components: {}
    };

    function ClassList(element) {
        this.element = element;
    }

    ClassList.prototype.contains = function contains(className) {
        return this.element.className.match(new RegExp("(^|\\s)" + className + "(\\s|$)"));
    };

    ClassList.prototype.add = function add(className) {
        if (!this.contains(className)) {
            this.element.className = (className.trim() + " " + this.element.className).trim();
        }
    };

    ClassList.prototype.remove = function remove(className) {
        if (this.contains(className))
            this.element.className = this.element.className.replace(new RegExp("(^|\\s)"+className+"(\\s|$)"), " ").trim();
    };

    ClassList.prototype.toggle = function toggle(className) {
        if (!this.contains(className))
            this.add(className);
        else
            this.remove(className);
    };

    Element.prototype._getClassList = function _getClassList() {
        if (!this.classList) {
            this.classList = new ClassList(this);
        }
        return this.classList;
    };

    Element.prototype._getClientPosition = function _getClientPosition() {
        var o = this;
        var x = o.offsetLeft;
        var y = o.offsetTop;
        while (o.offsetParent === defined) {
            o = o.offsetParent;
            x+= o.offsetLeft;
            y+= o.offsetTop;
        }
        return {"x":x,"y":y};
    };

    String.prototype.capitalize = function() {
        return this.charAt(0).toUpperCase() + this.slice(1);
    };

    String.prototype.startsWith = function(string) {
        return (this.substr(0, string.length) === string);
    };

    Number.prototype.mod = function(n) {
        return ((this % n) + n) % n;
    };

    function Dataset(element) {
        for (var i = 0; i < element.attributes.length; ++i) {
            var name = element.attributes[i].name.toLocaleLowerCase();
            if (name.match(/^data-/i)) {
                var matches = name.split("-");
                if (matches) {
                    name = "";
                    for (var j = 1; j < matches.length; ++j) {
                        if (j > 1) matches[j] = matches[j].capitalize();
                        name = name + matches[j];
                    }
                }

                this[name] = element.attributes[i].value;
            }
        }
    }

    Element.prototype._getDataset = function _getDataset() {
        if (!this.dataset) {
            this.dataset = new Dataset(this);
        }

        return this.dataset;
    };

    Element.prototype.show = function _show(time, steps) {
        GCU.show(this, time);
    };

    Element.prototype._hide = function _hide(time, steps) {
        GCU.hide(this, time);
    };

    Element.prototype.enableSwipe = function(options) {
        var dX, dY, T;
        var tT = options && options.timeTreshold || 200;
        var dT = options && options.distanceTreshold || 150;

        this.addEventListener('touchstart', function(e){
            var t = e.changedTouches[0];
            dX = t.pageX;
            dY = t.pageY;
            T = new Date().getTime();
            e.preventDefault();
        }, false);

        this.addEventListener('touchmove', function(e) {
            e.preventDefault();
        }, false);

        this.addEventListener('touchend', function(e) {
            var t = e.changedTouches[0];
            dX = t.pageX - dX;
            dY = t.pageY - dY;
            T = new Date().getTime() - T;

            if (T <= tT) {
                var swipe = new Event('touch');
                swipe.time = T;

                if (dY <= -dT) {
                    swipe.direction = 'up';
                    swipe.distance = dY;
                }
                else if (dY >= dT) {
                    swipe.direction = 'down';
                    swipe.distance = dY;
                }
                else if (dX <= -dT) {
                    swipe.direction = 'left';
                    swipe.distance = dX;
                }
                else if (dX >= dT) {
                    swipe.direction = 'right';
                    swipe.distance = dX;
                }
                else {
                    swipe = null;
                }
            }
            else {
                swipe = null;
            }
            e.preventDefault();
            if (swipe !== null) {
                this.dispatchEvent(swipe);
            }
        }, false);
    };


    Array.prototype.each = function(func, data) {
        for (var i = 0; i < this.length; i+=1) {
            var r = func.call(this[i], this[i] , i, data);
            if (r === false){
                break;
            }
        }
    };

    Array.prototype.rotateLeft = function() {
        var t = this.shift();
        this.push(t);
        return t;
    };

    Array.prototype.rotateRight = function() {
        var t = this.pop();
        this.unshift(t);
        return t;
    };

    NodeList.prototype.each = Array.prototype.each;
    HTMLCollection.prototype.each = NodeList.prototype.each;

    globals.TIMER = function Timer(options) {
        this.time = options.time ? options.time : 1000;

        var interval = undefined;
        var timeout = undefined;
        var progress = 0;
        var timer = this;

        this.start = function(time) {
            if (time !== undefined) {
                timer.time = time;
            }
            if (options.startCallback !== undefined) {
                options.startCallback();
            }

            if (interval){
                clearInterval(interval);
            }

            var progress = 0;

            interval = setInterval(function() {
                progress++;
                if (progress > 100) {
                    progress = 100;
                }
                if (options.progressCallback) {
                    options.progressCallback(progress);
                }
            }, timer.time / 100);

            if (timeout) {
                clearInterval(timeout);
            }

            timeout = setTimeout(function() {
                if (timeout) {
                    clearInterval(timeout);
                }
                if (interval) {
                    clearInterval(interval);
                }
                if (options.elapsedCallback) {
                    options.elapsedCallback();
                }
            }, timer.time);
        };

        this.stop = function() {
            if (timeout) clearInterval(timeout);
            if (interval) clearInterval(interval);

            if (options.stopCallback) options.stopCallback();
        };
    };

    globals.processPanelGroups = function() {
        var max = {};
        document.getElementsByClassName("PanelGroup").each(function(panel) {
            if (!panel.firstElementChild.className.startsWith('PanelGroup_'))
                return;
            var className = panel.firstElementChild.className;
            max[className] = Math.max(!max[className] ? 0 : max[className], panel.firstElementChild.offsetHeight);
        });

        for (var c in max) {
            document.getElementsByClassName(c).each(function(panel) {
                panel.parentNode.style.minHeight = max[c]+'px';
            });
        }
    };

    window.addEventListener('load', function() {
        (function() {
            var hn = document.getElementById("HeaderNavigation");
            var sns = document.getElementById("SideNavigationShortMenu");


            (function() {
                if (!hn) return;

                var hni;
                hn.addEventListener('click', function() {
                    if (sns) {
                        sns._getClassList().remove("SideNavigationShortMenuOpen");
                        console.log('remove("SideNavigationShortMenuOpen")');
                    }
                    hn._getClassList().toggle("HeaderNavigationOpen");
                    document.body._getClassList().toggle("ScrollOff");

                    if (hni) {
                        clearTimeout(hni);
                    }
                    hni = setTimeout(function() {
                        hn.classList.remove("HeaderNavigationOpen");
                        console.log('hn.classList.remove("HeaderNavigationOpen")');
                        document.body._getClassList().remove("ScrollOff");
                    }, 10000);
                });
            })();

            (function() {
                if (!sns) return;
                sns.addEventListener('click', function() {
                    sns._getClassList().toggle("SideNavigationShortMenuOpen");
                    console.log('toggle("SideNavigationShortMenuOpen")');


                    if (hn) {
                        hn._getClassList().remove("HeaderNavigationOpen");
                        console.log('hn._getClassList().remove("HeaderNavigationOpen")');
                        document.body._getClassList().remove("ScrollOff");
                    }
                });
            })();
        })();

        window.processPanelGroups();
    });

    window.addEventListener('resize', function() {
        /* jde, added 20/07/17 */
        window.GCU.jde = ( window.innerWidth < 809 ) ? 'small' : 'long';

        //console.log('resize;', window.innerHeight, window.innerWidth, window.outerHeight, window.outerWidth, globals.jde );
        window.processPanelGroups();
    });

    window.addEventListener("scroll", function() {
        document.getElementsByClassName('StickyBlock').each(function(e, i) {
            e._getDataset();
            e._getClassList();
            var r = e.getBoundingClientRect();
            var y = r.bottom - r.height;
            if (!e.fixed  && y <= 0 ) {
                e.fixed = window.pageYOffset;
                e.classList.add(e.dataset.class);
            }
            if (e.fixed && window.pageYOffset < e.fixed) {
                delete e.fixed;
                e.classList.remove(e.dataset.class);
            }
        });
    }, false);
})(this);
