/**
 * Created by jde on 28/07/2017.
 */
var MainApp = (function(mainCore) {

    //progressive enhancement
    mainCore.log = function(severity, msg, color) {
        // if the logging module has been loaded, then use its full functionality
        // otherwise just log a simple message
        if (mainCore.LoggingHandler && mainCore.LoggingHandler.logMessage) {
            mainCore.LoggingHandler.logMessage(severity, msg, color);
        } else {
            if (severity === 3) {
                color = "color:red;font-weight:bold";
            }
            console['log']("%c Severity: " + severity + " ---> " + msg + " (From mainCore!)", color);
        }
    };

    return mainCore;
}) ( MainApp || {} ); // using loose augmentation of MainApp

// MainApp.log( 1, 'hi', 'color:green;font-size:70px');


MainApp.XHRManager = XHRManager;
MainApp.LoggingHandler = LoggingHandler;
MainApp.PageUpdater = PageUpdater;
/*
MainApp.SlideManager = SlideManager;
MainApp.ContentLoader = ContentLoader;
*/