// jde, 21/02/17, added loadPDF coding

function debug(msg) {
    if (debugging == true) {
        var dbg = document.getElementById('debugArea');
        //alert( 'dbg!'+dbg+'!');
        if (dbg == null)
            alert('debug:' + msg);
        else {
            var txtNode = document.createTextNode(msg);
            dbg.appendChild(txtNode);
        }
    }
}

function showMessage(msg, whereAbouts, appendMode) {
    debugging =false;
    debug('showMessage:' + msg + whereAbouts + appendMode);

// switch off debugging for everything except output to the 'debugArea'
    if (whereAbouts != 'debugArea') {
        var tmpDebugging = debugging;
        debugging = false;
    }
    var where = document.getElementById(whereAbouts);
    if (where == null) { // can't find where in page
        alert('showMessage:' + msg)
    } else {
        if (appendMode == true) { // then append msg to where
            var tmp = where.innerHTML;
            where.innerHTML = tmp + msg;
        } else {
            //where.innerHTML = '';
            where.innerHTML = msg;
        }
    }

// now put debugging back to previous state
    if (whereAbouts != 'debugArea') {
        debugging = tmpDebugging;
    }
}

// creates an XMLHttpRequest instance
function createXMLHttpRequestObject() {
    // xmlHttp will store the reference to the XMLHttpRequest object
    var xmlHttp;
    // try to instantiate the native XMLHttpRequest object
    try {
        // create an XMLHttpRequest object
        xmlHttp = new XMLHttpRequest();
    }
    catch (e) {
        // assume IE6 or older
        try {
            xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
        }
        catch (e) {
        }
    }
    // return the created object or display an error message
    if (!xmlHttp)
        showMessage("Error creating the XMLHttpRequest object.", 'debugArea', true);
    else
        return xmlHttp;
}

// function executed when the state of the request changes
function handleStateChangeText(whereAbouts, preText, postText, appendMode) {
    debug('handleStateChangeText:' + whereAbouts + preText + postText + appendMode);
    // continue if the process is completed

    if (xhr.readyState == 4) {
        // continue only if HTTP status is "OK"
        if ((xhr.status >= 200 && xhr.status < 300) || (xhr.status == 304)) {
            try { // now place response in the chosen area of the page if found
                var where = document.getElementById(whereAbouts);
                if (where != null) {
                    // build the response
                    var responsTxt = preText + xhr.responseText + postText;
//alert( 'handleStateChangeText responseText:'+ responsTxt + ':' );
                    showMessage(responsTxt, whereAbouts, appendMode);
                } else {
                    throw new Error('Error :' + whereAbouts + ' not found on page!');
                }
            } catch (e) {
                // display error message
                showMessage(e.name + "(handleStateChangeText)Error reading the response:" + e.toString(), 'debugArea', true);
            }
        }
        else {
            // display status message
            showMessage("(handleStateChangeText)There was a problem retrieving the data:\n" + xhr.statusText + " (" + xhr.statusCode + ") ", 'debugArea', true);
        }
    }
}

// function executed when the state of the request changes
function waitForTextReply() {
//alert('waitForTextReply:');

    var responsTxt = '';
    if (xhr.readyState == 4) {  // continue if the process is completed
        // continue only if HTTP status is "OK"
        if ((xhr.status >= 200 && xhr.status < 300) || (xhr.status == 304)) {
            responsTxt = xhr.responseText;   // build the response
//alert( 'responseText:'+ responsTxt + ':' );
        }
        else {
            // display status message
            showMessage("(waitForTextReply)There was a problem retrieving the data:\n" + xhr.statusText + " (" + xhr.statusCode + ") ", 'debugArea', false);
        }
    }
    return responsTxt;
}

// performs a server request and assigns a callback function
function loadPage(pathname, whereAbouts, preText, postText, appendMode) {
    debug('loadPage:' + pathname + whereAbouts + preText + postText + appendMode);
    // continue only if xhr isn't void
    if (xhr) {
        // try to connect to the server
        try {
            // initiate server request
            xhr.open("GET", pathname + '?junk=' + Math.random(), true); // true => asynchronous call
            var txtMode = true;   // assume that we have text being returned
            if (txtMode)
//        xhr.setRequestHeader( "Cache-Control", "no-cache" );
//        xhr.setRequestHeader( "Pragma", "no-cache" );
                xhr.onreadystatechange = function () {
                    handleStateChangeText(whereAbouts, preText, postText, appendMode);
                };
            else
                xhr.onreadystatechange = function () {
                    handleStateChangeXML(whereAbouts);
                };
            xhr.send(null);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }
}

// performs a server request and assigns a callback function
function waitForPage(pathname, txtMode) {
    debug('waitForPage:' + pathname);
    var returnValue = '0';
    // continue only if xhr isn't void
    if (xhr) {
        // try to connect to the server
        try {
            debug('1 waitForPage:');
            // initiate server request
            xhr.open("GET", pathname + '?junk=' + Math.random(), false); // false => not an asynchronous call
            if (txtMode) {
//        xhr.setRequestHeader( "Cache-Control", "no-cache" );
//        xhr.setRequestHeader( "Pragma", "no-cache" );
                debug('2 waitForPage:');
                xhr.onreadystatechange = function () {
                    returnValue = waitForTextReply();
                }
            } else {
                xhr.onreadystatechange = function () {
                    handleStateChangeXML(whereAbouts); // xxx jde whereAbouts not got a value?
                }
            }
            xhr.send(null);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }
//alert( '3 waitForPage:' + returnValue );
    return returnValue;
}

// performs a server request and assigns a callback function
function loadHashPage(filename, anchor, whereAbouts, txtMode) {
    loadAndWaitPage(filename, whereAbouts, txtMode);
    // continue only if xhr isn't void
    if (xhr) {
        // try to connect to the server
        try {
            // initiate server request
            var url = document.referrer + '#topics_' + anchor;
            debug('loadHashPage url:' + url + ' document.referrer: ' + document.referrer);
            xhr.open("GET", url, true); // true => asynchronous call
            if (txtMode)
//        xhr.setRequestHeader( "Cache-Control", "no-cache" );
//        xhr.setRequestHeader( "Pragma", "no-cache" );
                xhr.onreadystatechange = function () {
                    handleStateChangeText(whereAbouts, false);
                };
            else
                xhr.onreadystatechange = function () {
                    handleStateChangeXML(whereAbouts);
                };
            xhr.send(null);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }
}

// performs a server request and assigns a callback function
function loadPHPPage(url, whereAbouts, preText, postText, appendMode) {
    debug('loadPHPPage:' + url + ':' + whereAbouts + ':' + preText + ':' + postText + ':' + appendMode + ':');
    // continue only if xhr isn't void
    if (xhr) {
        // try to connect to the server
        try {
            // initiate server request
            xhr.open("GET", url, true); // true => asynchronous call
            var txtMode = true;  // xxx for the time being assume that we always want straight text back from php call
            if (txtMode)
//        xhr.setRequestHeader( "Cache-Control", "no-cache" );
//        xhr.setRequestHeader( "Pragma", "no-cache" );
                xhr.onreadystatechange = function () {
                    handleStateChangeText(whereAbouts, preText, postText, appendMode);
                };
            else
                xhr.onreadystatechange = function () {
                    handleStateChangeXML(whereAbouts);
                };
            xhr.send(null);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }
}

// function executed when the state of the request changes
function handleStateChangeXML(whereAbouts) {
    debug('handleStateChangeXML');

    // continue if the process is completed
    if (xhr.readyState == 4) {
        // continue only if HTTP status is "OK"
        if (xhr.status == 200) {
//debug( 'inside if - before try ');
            try {
                // retrieve the response
                var responseXML = xhr.responseXML;
                if (responseXML != null) {
                    // do something with the response
//debug( 'displayArea:' + displayArea );
                    var textFormat = responseXML.documentElement;
//debug( 'textFormat:' + textFormat );
                    var textFormatHTML = textFormat.getElementsByTagName("textformat");
                    var theOutPut = textFormatHTML[0].firstChild.nodeValue;
//debug( 'theOutPut:' + theOutPut );
                    document.getElementById(whereAbouts).innerHTML = theOutPut;  // xxx this needs work
                }
            }
            catch (e) {
                // display error message
                showMessage("Error reading the response: " + e.toString(), 'debugArea', true);
            }
        }
        else {
            // display status message
            showMessage("(handleStateChangeXML:) There was a problem retrieving the data:\n" + xhr.statusText + " (" + xhr.statusCode + ") ", 'debugArea', true);
        }
    }
}

// Added Dev 23/08/09
function updateHiddenPathname(pathname) {
    //set up the hidden field name for the linked file
    var hdn = document.getElementById('linkName');
    if (hdn != null) {
        hdn.value = pathname;
    }
}

// Added Dev 13/08/09
function loadImage(pathname, whereAbouts, preText, postText, appendMode) {
    debug('loadImage:' + pathname + ':' + whereAbouts);
    var ok = false;
    var div = document.getElementById(whereAbouts);
    if (div != null) {
        var imgHTML = preText + '<img src="' + pathname + '" width="100%" height="100%" alt="slide:' + pathname + '" border="0" />' + postText;
        showMessage(imgHTML, whereAbouts, appendMode);
        ok = true;
    }
    return ok;
}

function loadTXTSnippet(pathname, whereAbouts, preText, postText, appendMode) {
//alert( 'loadTXTSnippet:' + pathname +':' +whereAbouts + ':');
    try {
        // initiate server request
        var url = pathname;
        xhr.open("GET", url, true); 				// true => asynchronous call
        xhr.onreadystatechange = function () {
            handleStateChangeText(whereAbouts, preText, postText, appendMode);
        };
        xhr.send(null);
    }
        // display an error in case of failure
    catch (e) {
        showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
    }
}

// jde, 24/5/17, added support for java files
// gets the file extension from the given file and then tries to load that page
// into a specific area of the current page.
function loadSnippet(pathname, whereAbouts, appendMode) {
    //alert( 'loadSnippet:' + pathname +':' + whereAbouts+':'+appendMode+':' );
    debug('loadSnippet:' + pathname + ':' + whereAbouts + ':' + appendMode + ':');
    var preText, postText;
    // continue only if xhr isn't void
    if (xhr) {
        var parts = filenameSplit(pathname);
        var ext = parts[2];
        var url = parts[0] + parts[1] + parts[2];
        if (ext == '')
            showMessage('No file extension found', 'debugArea', true);
        else {
//alert( 'FilenameExtension is:' + ext );
            switch (ext) {
                case '.txt' : {
                    var id = 'makeOneUp' + Math.random();
                    preText = '<div class="open" id="' + id + '">';
                    preText += '<img src="./src/src/images/minus.gif" alt="expand" onclick="javascript:toggle(\'' + id + '\');"/>' + parts[1];
                    preText += '<div class="item-body" id="item-body"><pre>';
                    postText = '</pre></div></div>';
                    loadTXTSnippet(pathname, whereAbouts, preText, postText, appendMode);
                    break;
                }
                case '.js' :
                case '.pas' :
                case '.java' : {
                    preText = '<pre class="code">';
                    postText = '</pre>';
                    loadTXTSnippet(pathname, whereAbouts, preText, postText, appendMode);
                    break;
                }
                case '.php' :  {
                    var parameters = parts[3];
                    preText = '';
                    postText = '';
                    debug('loadPHPPage:'+ pathname + ':'+whereAbouts + ':'+appendMode +':');
                    loadPHPPostPage(url, parameters, whereAbouts, preText, postText, appendMode);
                    break;
                }
                case '.jpg' :
                case '.gif' :
                case '.PNG' :  {
                    preText = '';
                    postText = '';
                    var ok = loadImage(pathname, whereAbouts, preText, postText, appendMode);
                    if (ok) updateHiddenPathname(pathname);
                    break;
                }
                case '.sbr' :
                case '.hdr' :
                case '.ftr' :  {
                    preText = '';
                    postText = '';
//			     loadTXTSnippet( pathname, whereAbouts, preText, postText, appendMode );
                    loadPage(pathname, whereAbouts, preText, postText, appendMode);  // html files end up here
                    setupKeyTrap();
                    break;
                }
                case '.pdf' : {
                    preText = '';
                    postText = '';
                    loadPDF(pathname, whereAbouts, preText, postText, appendMode);
                    break;
                }
                default :
                    preText = '';
                    postText = '';
                    loadPage(pathname, whereAbouts, preText, postText, appendMode);  //hdr, sbr, ftr, html files end up here
            }
        }
    }
}

// jde, added 01/12/2016,
function loadTwiceSnippet(pathname, whereAbouts1, whereAbouts2, appendMode) {
    loadSnippet(pathname, whereAbouts1, appendMode);
    loadSnippet(pathname, whereAbouts2, appendMode);
}

// jde, 03/12/16, added to deal with JSON data being sent back
// function executed when the state of the request changes and JSON being returned
function handleStateChangeJSON(whereAbouts, preText, postText, appendMode) {
    debug('handleStateChangeText:' + whereAbouts + preText + postText + appendMode);
    // continue if the process is completed

    if (xhr.readyState == 4) {
        // continue only if HTTP status is "OK"
        if ((xhr.status >= 200 && xhr.status < 300) || (xhr.status == 304)) {
            try { // now place response in the chosen area of the page if found
                var where = document.getElementById(whereAbouts);
                if (where != null) {
                    // build the response
                    var obj = JSON.parse(xhr.responseText);
                    var responsTxt = '';
                    if ( obj.response == 'OK' ) {
                        responsTxt  = preText + obj.message + postText;
//alert( 'handleStateChangeJSON responseText:'+ responsTxt + ':' );
                    } else {
                        responsTxt = preText + obj.response + postText;
                    }
                    showMessage(responsTxt, whereAbouts, appendMode);
                } else {
                    throw new Error('Error :' + whereAbouts + ' not found on page!');
                }
            } catch (e) {
                // display error message
                showMessage(e.name + "(handleStateChangeText)Error reading the response:" + e.toString(), 'debugArea', true);
            }
        }
        else {
            // display status message
            showMessage("(handleStateChangeText)There was a problem retrieving the data:\n" + xhr.statusText + " (" + xhr.statusCode + ") ", 'debugArea', true);
        }F
    }
}

// jde, added 01/12/2016, send a post request
// performs a server request and assigns a callback function
function loadPHPPostPage(url, parameters, whereAbouts, preText, postText, appendMode) {
    debug('loadPHPPostPage:' + url + ' parameters:' + parameters + ' :' + whereAbouts + ':' + preText + ':' + postText + ':' + appendMode + ':');
    // continue only if xhr isn't void
    if (xhr) {
        // try to connect to the server
        try {
            // initiate server request
            xhr.open("POST", url, true); // true => asynchronous call
            var txtMode = true;  // xxx for the time being assume that we always want straight text back from php call
            if (txtMode) {
//        xhr.setRequestHeader( "Cache-Control", "no-cache" );
//        xhr.setRequestHeader( "Pragma", "no-cache" );
                xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                //xhr.setRequestHeader("Content-length", parameters.length);
                xhr.onreadystatechange = function () {
                    handleStateChangeText( whereAbouts, preText, postText, appendMode);
 //                   handleStateChangeJSON(whereAbouts, preText, postText, appendMode);
                }
            } else {
                xhr.onreadystatechange = function () {
                    handleStateChangeXML(whereAbouts);
                }
            }
            xhr.send(parameters);
        }
            // display an error in case of failure
        catch (e) {
            showMessage("Can't connect to server:\n" + e.toString(), 'debugArea', true);
        }
    }
}

function loadSnippetMCQ(id, whereAbouts, appendMode) {
    //alert( 'loadSnippet:' + pathname +':' + whereAbouts+':'+appendMode+':' );
    debug('loadSnippetMCQ:' + id + ':' + whereAbouts + ':' + appendMode + ':');
    var url = 'http://localhost/qubed3new/helper/backend/getQuestionIdDummy.php';
    var parameters = 'id='+id;
    var preText = '';
    var postText = '';
//alert('loadPHPPage:'+ pathname + ':'+whereAbouts + ':'+appendMode +':');
//    loadPHPPostPage(url, parameters, whereAbouts, preText, postText, appendMode);

    var page = "http://localhost/qubed3new/qubed.php?admin=showQuestions&id=010180213";

    opendialog(page);

    function opendialog(page) {
        var iframe = '<iframe style="border: 0; " src="' + page + '" width="100%" height="100%" seamless=""></iframe>';

        var $dialog = $('#mainMiddleContent')
            .html('<a href="#" data-rel="back" class="ui-btn ui-btn-b ui-corner-all ui-shadow ui-btn-a ui-icon-delete ui-btn-icon-notext ui-btn-right">Close</a>'
                + iframe)
            .dialog({
                title: "Page",
                autoOpen: false,
                dialogClass: 'dialog_fixed, ui-widget-header',
                modal: true,
                height: 500,
                minWidth: 600,
                minHeight: 600,
                draggable:true,
                buttons: { "Ok": function () { $(this).dialog("close"); },
                    "close": function () { $(this).remove(); } }
            });
        $dialog.dialog('open');
    }
}

// Added Dev 21/02/17
function loadPDF(pathname, whereAbouts, preText, postText, appendMode) {
    debug('loadPDF:' + pathname + ':' + whereAbouts);
    var ok = false;
    var div = document.getElementById(whereAbouts);
    if (div != null) {
        var pdfHTML = '<embed width = "600" height = "450" src = "' + pathname + '" type = "application/pdf" ></embed>';
        showMessage(pdfHTML, whereAbouts, appendMode);
        ok = true;
    }
    return ok;
}


function loadLectureDetails( filename, whereAbouts, appendMode ) {
    xhr.onreadystatechange = function ( ) {
        if (xhr.readyState==4 && xhr.status==200) {
            // Added Dev 11/07/17
            var slideDetails = {};
            var slides = JSON.parse( xhr.responseText );
            var foldername = slides.contentFolder;   // as we're dealing with lectures they live in the lectures folder ;)
            SlideManager.startup(foldername);
            var slideCount = slides.slides.length;
            slideDetails.slideCount = slideCount;
            SlideManager.load( slideCount );   // get the slide manager ready with the number of slides in set
            slideDetails.titles = [];
            var tmpString = "";
            var html = "<p>No: of slides:" + slideCount + "</p>";
            for (var index = 0; index < slideCount; index ++){
                var slideNumber = index + 1;
                tmpString = slides.slides[index].title;
                html += '<button id="but' + slideNumber +'" type="button" onclick="SlideManager.display(' + slideNumber + ');">' + tmpString + '</button>';
                console.log( index + '. ' + tmpString );
            }
            showMessage( html, whereAbouts, appendMode );
            loadSnippet( './dsa/lectures/slideMenu.phtml', 'contentFooter', false );
        }
    };
    xhr.open("GET", filename, true);
    xhr.send();
}

// Added Dev 18/07/17
function loadLabDetails( filename, whereAbouts, appendMode ) {
    xhr.onreadystatechange = function ( ) {
        if (xhr.readyState==4 && xhr.status==200) {
            var details = JSON.parse( xhr.responseText );
            var filename = details.contentFolder + details.filename;   // as we're dealing with labs they live in the labs folder ;)
            var html = "";
            html += '<li><a onclick="loadSnippet(' + "'" + filename + "', 'mainMiddleContent', false );" + '">' + details.title + '</a></li>';

            showMessage( '', 'contentFooter', false );   // clear out any slide menu stuff
            if ( details.solutions != "" ) {
                var solutionFilename = details.contentFolder + details.solutions;
                html += '<li><a onclick="loadSnippet(' + "'" + solutionFilename + "', 'mainMiddleContent', false );" + '">' + details.title + ' solutions.</a></li>';
            }
            if ( details.additional != "" ) {
                var additionalFilename = details.contentFolder + details.additional;
                html += '<li><a onclick="loadSnippet(' + "'" + additionalFilename + "', 'mainMiddleContent', false );" + '">' + details.title + ' more exercises.</a></li>';
            }
            console.log( html );
            showMessage( html, whereAbouts, appendMode );
        }
    };
    xhr.open("GET", filename, true);
    xhr.send();
}

// Added Dev 19/07/17
function loadContactDetails( filename, whereAbouts, appendMode ) {
    xhr.onreadystatechange = function ( ) {
        if (xhr.readyState==4 && xhr.status==200) {
            var details = JSON.parse( xhr.responseText );
            var people = details.people;
            var html = "";
            for (var index = 0; index < people.length; index ++){
                var pathname = details.contentFolder + people[index].filename;
                html += '<li><a onclick="loadSnippet(' + "'" + pathname + "', 'mainMiddleContent', false );" + '">' + people[index].title + '</a></li>';
            }

            console.log( html );
            showMessage( html, whereAbouts, appendMode );
        }
    };
    xhr.open("GET", filename, true);
    xhr.send();
}

// Added Dev 19/07/17
function loadTutDetails( filename, whereAbouts, appendMode ) {
    xhr.onreadystatechange = function ( ) {
        if (xhr.readyState==4 && xhr.status==200) {
            var details = JSON.parse( xhr.responseText );
            var filename = details.contentFolder + details.filename;
            var html = "";
            html += '<li><a onclick="loadSnippet(' + "'" + filename + "', 'mainMiddleContent', false );" + '">' + details.title + '</a></li>';

            showMessage( '', 'mainMiddleContentFooter', false );   // clear out any slide menu stuff
            if ( details.solutions != "" ) {
                var solutionFilename = details.contentFolder + details.solutions;
                html += '<li><a onclick="loadSnippet(' + "'" + solutionFilename + "', 'mainMiddleContent', false );" + '">' + details.title + ' solutions.</a></li>';
            }
            if ( details.additional != "" ) {
                var additionalFilename = details.contentFolder + details.additional;
                html += '<li><a onclick="loadSnippet(' + "'" + additionalFilename + "', 'mainMiddleContent', false );" + '">' + details.title + ' more exercises.</a></li>';
            }
            console.log( html );
            showMessage( html, whereAbouts, appendMode );
        }
    };
    xhr.open("GET", filename, true);
    xhr.send();
}

