<?php
require_once("src/php/db.inc.php");
require_once("src/php/cloudClass.php");
require_once("src/php/historyClass.php");

$the_visitor = setUp();
$the_term = getTermValue();
$the_checkBoxValue = getCheckBoxValue();
$history = new History();
$the_history = $history->getHistoryList($the_visitor);
$the_recent_searches = $history->showRecentSearches($the_history);
$the_definition = doDefinition($the_term, $the_visitor, $the_history);
$cloud = new Cloud(MAXCLOUDSIZE);
$the_cloud = $cloud->doCloud();
?>

<!DOCTYPE html>
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>Glossary</title>
	<link rel="stylesheet" href="src/css/navbar.css" type="text/css" media="screen" />
<script type="text/javascript">
// <![CDATA[
if (document.getElementById) window.onload = function() {
	var sel = document.getElementById("term2");
	if (sel)
		sel.onchange =
			function() {
				var t = document.getElementById("term1");
				t.value = sel.value;
			}
}
// ]]>
</script></head>
<body>
<div id="cloud">
<?php echo $the_cloud; ?>
</div>
<br/><br/>
<form action="testGlossary.php" method="get">
<div id="form">
<label for="term1">Glossary term</label>
<input name="term1" id="term1" type="text" size="20" value = "<?= $the_term ?>"/>
<?php echo $the_recent_searches; ?>
<input name="lookup" id="lookup" type="submit" value="Look Up" />
<label><input name="checkboxValue" id="exactValue" type="checkbox" value = "Y" />Exact Word?</label>
</div>
</form>
<div id="definition">
<?php echo $the_definition; ?>
</div>
<script language="javascript" type="text/javascript" src="src/js/jquery-2.1.4.js"></script>
<script language="javascript" type="text/javascript" src="src/js/jquery-ui.js"></script>

<script type="text/javascript" src="src/js/XHRManager.js"></script>
<script type="text/javascript" src="src/js/LoggingHandler.js"></script>
<script type="text/javascript" src="src/js/PageUpdater.js"></script>

<script type="text/javascript" src="src/js/GlobalData.js"></script>
<script type="text/javascript" src="src/js/MainApp.js"></script>

<script language="javascript" type="text/javascript" src="src/js/MenuManager.js"></script>
<script language="javascript" type="text/javascript" src="src/js/SlideManager.js"></script>
<script language="javascript" type="text/javascript" src="src/js/ContentLoader.js"></script>

<script>
	$(window).load(function() {
		var xhr = GlobalData.xhr;
		ContentLoader.initialise( xhr );
		SlideManager.initialise('.', 'definition', 1);
	});

</script>
</body>
</html>
