<?php
/************************************************************************
 * FILE:   header.php                                                   *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file is used to maintain a consistent header on the top of      *
 * every page in the application. This file is also used to determine   *
 * the progress as displayed on the progress bar and to create the      *
 * "Back" and "Next" links.                                             *
 *                                                                      *
 * CLASSES USED:                                                        *
 *    - None                                                            *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - "includes/properties.php"                                       *
 *    - "includes/sessionHandler.php"                                   *
 *    - "includes/browserCheck.php"                                     *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *     - slashify   - Used to add slashes to form input, if necessary.  *
 *                                                                      *
 *     - deslashify - Used to remove slashes from form input, if        *
 *                    necessary.                                        *
 *                                                                      *
 * JAVASCRIPT:                                                          *
 *    - "javascript/ajax.js"                                            *
 *    - "javascript/popUp.js"                                           *
 *    - "javascript/standard.js"                                        *
 *    - "javascript/textarea.js"                                        *
 *                                                                      *
 * STYLE SHEETS:                                                        *
 *    - "css/mainStyles.css.php"                                        *
 *    - "css/popUp.css.php"                                             *
 *    - "iepngfix.htc" (IE only)                                        *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - Additional JavaScript and CSS files can be included, depending  *
 *      on whether the parent page populates the $moreCSS and           *
 *      $moreJavascript variables.                                      *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

if(!isset($path))
   $path = "";
if(!isset($pageTitle))
   $pageTitle = "";

// Include necessary files.
include_once($path."includes/properties.php");
require_once($path."includes/sessionHandler.php");
include_once($path."includes/browserCheck.php");

// Find out what page we are on
$currentFile = strtolower($_SERVER["SCRIPT_NAME"]);
$parts = explode('/', $currentFile);
$currentFile = $parts[count($parts) - 1];

// If we are on the last page and the user has
// disabled JavaScript, then we use this method
// to capture the form information and show the
// PDF document.
if(isset($_GET["showPDF"]) && $currentFile == $evaluationToolPages[count($evaluationToolPages)-1])
{
   header("Location: pdf/index.php");
}


if($currentFile == "index.php")
   $noHeader = true;

// Set the onLoad functions.
if(isset($onLoad))
   $onLoad = "javascript:initPopUpElements();".$onLoad;
else
   $onLoad = "javascript:initPopUpElements();";

// Find out what step we on
if(($page = array_search($currentFile, $evaluationToolPages)) === false)
{
   if(($page = array_search($currentFile, $educationalPages)) === false)
   {
      unset($page);
      unset($percent);
   }
   else
   {
      $page++;
      // We leave out the last item in the educational pages because
      // it is simply the link back to the index page.
      $percent = (int) (($page/((count($educationalPages)-1)))*100);
   }
}
else
{
   $page++;

   $moreCSS = "css/popUp.css.php";
   $onLoad .= "initCheckboxRadioButtons();setBackButton();";
   $includeForm = true;

   // Get percentage of completion
   $percent = (int) (($page/(count($evaluationToolPages)))*100);
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en" >
<head>
<title><?php echo $websiteName;
                if(!empty($pageTitle))
                   echo " -- " . $pageTitle;
                else if(strpos($_SERVER["PHP_SELF"], "/index.php") === false)
                   echo " - " . str_replace("_", " ", $_SERVER["PHP_SELF"]); ?></title>

<meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1" />
<script type="text/javascript" src="javascript/standard.js"></script>
<script type="text/javascript" src="javascript/ajax.js"></script>
<script type="text/javascript" src="javascript/popUp.js"></script>
<script type="text/javascript" src="javascript/textarea.js"></script>

<?php
   if(isset($moreJavascript))
   {
      if(is_array($moreJavascript))
         foreach($moreJavascript as $js)
            echo "   <script type=\"text/javascript\" src=\"$js\"></script>\n";
      else
         echo "   <script type=\"text/javascript\" src=\"$moreJavascript\"></script>\n";
   }
   ?>
   <link rel="stylesheet" type="text/css" title="main_css" href="<?php echo $path; ?>css/mainStyles.css.php" />
   <link rel="stylesheet" type="text/css" title="main_css" href="<?php echo $path; ?>css/popUp.css.php" />
   <link rel="stylesheet" type="text/css" title="main_css" href="<?php echo $path; ?>css/calendar.css.php" />
<?php
   if(isset($moreCSS))
   {
      if(is_array($moreCSS))
         foreach($moreCSS as $css)
            echo "   <link rel=\"stylesheet\" type=\"text/css\" href=\"$css\" />\n";
      else
         echo "   <link rel=\"stylesheet\" type=\"text/css\" href=\"$moreCSS\" />\n";
   }

if($ie && (float) $browserVersion < 7)
{
   ?>
 <style type="text/css">
 /*
  USAGE: All you have to do is include this one line in your CSS file, with the
  tag names to which you want the script applied:
 */

 .twoColumnBoxWrapper { behavior: url("iepngfix.htc") }

 /*
  Alternatively, you can specify that this will apply to all tags like so:
   * { behavior: url(iepngfix.htc) }
 */

 </style>
<?php
}
?>

</head>
<?php
echo "<body";
if(isset($onLoad))
   echo " onload=\"$onLoad\"";
echo ">";

/* Moved to footer */
//echo "<div id=\"localInfo\"><a href=\"localCopyrightInfo.php?backLink=".urlencode($_SERVER["PHP_SELF"])."\">Local Copyright Information</a></div>";
if(!isset($noHeader) || !$noHeader)
{
?>


<div id="contentWrapper">

   <div id="header">

   <?php
   if(isset($percent))
   {
   ?>

      <div id="completionDiv">
         <span class="textual"><?php echo $percent; ?>% complete</span>
         <div id="completionBar"><span style="width:<?php echo $percent; ?>px;">&nbsp;</span></div>
      </div>
   <?php
   }
   ?>
      <a href="index.php"><img src="images/blank.gif" style="float:left;border:0;height:42px;width:52px;" alt="Fair Use Evaluator" title="Fair Use Evaluator" /></a><h1><a href="index.php">Fair Use<br />Evaluator</a></h1>
   </div>

   <div id="content">

<?php
   // If we are in the tool, then we need to include the form tag.
   if(isset($includeForm) && $includeForm)
   {
      if(isset($evaluationToolPages[($page)]))
         echo "      <form action=\"". $evaluationToolPages[($page)]. "\" id=\"fairUseForm\" method=\"post\">\n";
      else
         echo "      <form action=\"". $currentFile. "?showPDF\" id=\"fairUseForm\" method=\"post\">\n";
   }
}
else
{
?>
   <div id="frontWrapper">
<?php
}




   // Used for non-Javascript users.
   if(isset($_GET["backLink"]))
   {
      echo "   <div id=\"controlsTop\">\n";
      echo "      <a href=\"".$_GET["backLink"]."\" id=\"backLinkTop\">Back</a>\n";
      echo "   </div>";
      echo "   <div class=\"clearBlock\"></div>";
   }
   // Used for the evaluation tool pages.
   else if(($thisPage = array_search($currentFile, $evaluationToolPages)) !== false)
   {
      echo "<div id=\"controlsTop\">\n";

      if(isset($evaluationToolPages[($thisPage-1)]))
      {
         echo "      <input type=\"hidden\" name=\"prevPage\"  id=\"prevPageTop\" value=\"".$evaluationToolPages[($thisPage-1)]."\" />\n";
         echo "      <a href=\"".$evaluationToolPages[($thisPage-1)]."\" id=\"backLinkTop\">Back</a>\n";
      }
      else if($currentFile == $evaluationToolPages[$thisPage])
      {
         echo "      <input type=\"hidden\" name=\"prevPage\"  id=\"prevPageTop\" value=\"index.php\" />\n";
         echo "      <a href=\"index.php\" id=\"backLinkTop\">Back</a>\n";
      }
      else
         echo "      <a href=\"#\" id=\"backLinkTop\" class=\"noLink\">Back</a>\n";

      if(isset($evaluationToolPages[($thisPage+1)]))
         echo "      <input type=\"submit\" name=\"nextLink\" value=\"Next\" id=\"nextLinkTop\" />\n";
      else
         echo "      <a href=\"#\" id=\"nextLinkTop\" class=\"noLink\">Next</a><br />\n";

      echo "   </div>";
      echo "   <div class=\"clearBlock\"></div>";
   }
   // Used for the educational pages.
   else if(($thisPage = array_search($currentFile, $educationalPages)) !== false)
   {
      // Make sure that the back link never ends up on the home page.
      // This was added to account for the looping back around to the
      // index page from the educational portion of the application.
      echo "   <div id=\"controlsTop\">\n";
      if(isset($educationalPages[($thisPage-1)]) && $currentFile != "index.php")
         echo "      <a href=\"".$educationalPages[($thisPage-1)]."\" id=\"backLinkTop\">Back</a>\n";
      else if($currentFile == $educationalPages[$thisPage]  && $currentFile != "index.php")
         echo "      <a href=\"index.php\" id=\"backLinkTop\">Back</a>\n";
      else
         echo "      <a href=\"#\" id=\"backLinkTop\" class=\"noLink\">Back</a>\n";

      if(isset($educationalPages[($thisPage+1)]))
         echo "      <a href=\"".$educationalPages[($thisPage+1)]."\" id=\"nextLinkTop\">Next</a>\n";
      else
         echo "      <a href=\"#\" id=\"nextLinkTop\" class=\"noLink\">Next</a>\n";
      echo "   </div>";
      echo "   <div class=\"clearBlock\"></div>";
      //echo "</div>";
   }


/*********************************************************
 * FUNCTION: slashify                                    *
 *                                                       *
 * PURPOSE: Used to add slashes to form input, if        *
 *          necessary.                                   *
 *                                                       *
 * PARAMETERS:                                           *
 *     input - String data to be processed.              *
 *                                                       *
 * RETURNS: input with slashes added before quotes, if   *
 *          necessary.                                   *
 *                                                       *
 *********************************************************/
function slashify($input)
{
   // Check if magic quotes is turned on.
   if(get_magic_quotes_gpc())
      return $input;
   else
      return addslashes($input);
}


/*********************************************************
 * FUNCTION: deslashify                                  *
 *                                                       *
 * PURPOSE: Used to remove slashes to form input, if     *
 *          necessary.                                   *
 *                                                       *
 * PARAMETERS:                                           *
 *     input - String data to be processed.              *
 *                                                       *
 * RETURNS: input with slashes removed before quotes, if *
 *          necessary.                                   *
 *                                                       *
 *********************************************************/
function deslashify($input)
{
   // Check if magic quotes is turned on.
   if(get_magic_quotes_gpc())
      return stripslashes($input);
   else
      return $input;
}

?>