<?php

if(!isset($path))
   $path = "";
if(!isset($pageTitle))
   $pageTitle = "";

include_once($path."includes/properties.php");
require_once($path."includes/sessionHandler.php");
include_once($path."includes/browserCheck.php");
include_once($path."includes/processPopUps.php");

// If we are on the last page and the user has
// disabled JavaScript, then we use this method
// to capture the form information and show the
// PDF document.
if(isset($_GET["showPDF"]) && $currentFile == $evaluationToolPages[count($evaluationToolPages)-1])
{
   header("Location: pdf/index.php");
}


// Set the onLoad functions.
if(isset($onLoad))
   $onLoad = "javascript:initPopUpElements();initToolTips();".$onLoad;
else
   $onLoad = "javascript:initPopUpElements();initToolTips();";

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en" >
<head>
<title><?php echo $websiteName;
                if(!empty($pageTitle))
                   echo " -- " . $pageTitle; ?></title>

<meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1" />
<script type="text/javascript" src="javascript/standard.js"></script>
<script type="text/javascript" src="javascript/ajax.js"></script>
<script type="text/javascript" src="javascript/popUp.js"></script>

<?php
   if(isset($moreJavascript))
   {
      if(is_array($moreJavascript))
         foreach($moreJavascript as $js)
            echo "   <script type=\"text/javascript\" src=\"$js\"></script>\n";
      else
         echo "   <script type=\"text/javascript\" src=\"$moreJavascript\"></script>\n";
   }
   ?>
   <link rel="stylesheet" type="text/css" title="main_css" href="<?php echo $path; ?>css/mainStyles.css.php" />
   <link rel="stylesheet" type="text/css" title="main_css" href="<?php echo $path; ?>css/popUp.css.php" />
<?php
   if(isset($moreCSS))
   {
      if(is_array($moreCSS))
         foreach($moreCSS as $css)
            echo "   <link rel=\"stylesheet\" type=\"text/css\" href=\"$css\" />\n";
      else
         echo "   <link rel=\"stylesheet\" type=\"text/css\" href=\"$moreCSS\" />\n";
   }

if($ie && (float) $browserVersion < 7)
{
   ?>
 <style type="text/css">
 /*
  USAGE: All you have to do is include this one line in your CSS file, with the
  tag names to which you want the script applied:
 */

 .twoColumnBoxWrapper { behavior: url("iepngfix.htc") }

 /*
  Alternatively, you can specify that this will apply to all tags like so:
   * { behavior: url(iepngfix.htc) }
 */

 </style>
<?php
}
?>
<script type="text/javascript">

  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', 'UA-32457715-1']);
  _gaq.push(['_trackPageview']);

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();
</script>
</head>
<?php
echo "<body";
if(isset($onLoad))
   echo " onload=\"$onLoad\"";
echo ">";

echo "<script type=\"text/javascript\" src=\"javascript/tooltips/tooltip.js\"></script>\n";

if($ie)
   echo "<div style=\"height:1%;\"></div>\n";

echo "<div id=\"contentWrapper\">\n";

/* No header - First page only */
if(isset($frontPage) && $frontPage)
{
   echo "<div class=\"frontWrapper\">\n";

   echo "<h1>Exceptions for Instructors <span><a href=\"#\" class=\"smallLink noLink\">[note]</a> in U.S. Copyright Law <a href=\"showNote.php?n=indexnote\" class=\"toolTip smallLink\">[note]</a></span></h1>\n";
}
else
{
   echo "\n<h1><a href=\"index.php\"><img src=\"images/blank.gif\" alt=\"".$websiteName."\"/></a><a href=\"index.php\">Exceptions for Instructors <span>in U.S. Copyright Law</span></a></h1>";
}


$firstLink = "index.php?startOver=true";
$pdfLink   = "createpdf.php";

?>




<?php
/********************************************************/
// Added a couple of small functions to help with input
// from the form fields.
/********************************************************/
function slashify($input)
{
   if(get_magic_quotes_gpc())
      return $input;
   else
      return addslashes($input);
}

function deslashify($input)
{
   if(get_magic_quotes_gpc())
      return stripslashes($input);
   else
      return $input;
}

?>