<?php
require('fpdf.php');

// Extends FPDF class to allow for
// header and footer methods.
class PDF extends FPDF
{

   var $footnoteCounter = 1;

   //Page header
   function Header()
   {
      //Logo
      //$tmp = $this->Image('asdmBannerMenu.jpg',$this->lMargin,$this->tMargin, $this->w - $this->lMargin - $this->rMargin);
      //$this->Ln($tmp["h"]);
   }

   //Page footer
   function Footer()
   {
      //Position at 1.5 cm from bottom
      $this->SetY( (-1 * ($this->bMargin)) );
      //Arial italic 8
      $this->SetFont('Arial','',8);

      $this->SetLineWidth($lineHeight);
      $this->SetDrawColor(204,204,204);
      $this->Rect($this->GetX(),$this->GetY(),($this->pageWidth - ($this->defaultMargin*1.5)),"F");

      $this->Ln(5);

      $this->SetX(205);
      $this->Write(9, "Compiled using the ");
      $this->SetFont("","B");
      $this->Write(9, "Exceptions for Instructors eTool ");
      $this->SetFont("","");
      $this->Write(9, "[cc] 2009");
      $this->Ln();
      $this->SetX(150);
      $this->Write(9, "Michael Brewer & the Office for Information Technology Policy  |  ");
      $this->SetTextColor(0,0,255);
      $this->Write(9, "http://librarycopyright.net/etool/", "http://librarycopyright.net/etool/");
   }

   function DrawHR($lineHeight=5, $addMargins=true)
   {
      $previousLineWidth = $this->LineWidth;

      if($addMargins)
      {
         $this->Ln();
         $this->Ln();
         $this->Ln();
      }

      $this->SetLineWidth($lineHeight);
      $this->Rect($this->GetX(),$this->GetY(),($this->pageWidth - ($this->defaultMargin*1.5)),"F");

      if($addMargins)
      {
         $this->Ln();
         $this->Ln();
      }

      $this->SetLineWidth($previousLineWidth);
   }

   function ShowNotes($notesArray)
   {
      $mainNote = explode("||||REPLACE_WITH_FOOTNOTE||||", $notesArray["mainNotes"]);

      if($this->GetY() > 600)
         $this->AddPage();

      for($a = 0, $b= $this->footnoteCounter, $len = count($mainNote)-1; $a < $len; $a++, $b++)
      {
         $this->SetFont("", "B");
         $this->SetFontSize(12);
         //$this->Write(14, "This width: " . $this->GetStringWidth($mainNote[$a])); $this->Ln();

         $this->Write(14, $mainNote[$a]);

         $this->SetFontSize(8);
         $this->SetTextColor(0,0,255);
         $this->Cell($this->GetStringWidth(($b)), 8,($b), 0, 0, "L");
         //$this->Write(14, ($a+1));
         $this->SetTextColor(0,0,0);
      }

      $this->SetFont("", "B");
      $this->SetFontSize(12);
      $this->Write(14, $mainNote[count($mainNote)-1]);

      if($notesArray["answer"])
      {
         $this->SetTextColor(0,176,80);
         $this->Write(14, "  YES");
      }
      else
      {
         $this->SetTextColor(192,0,0);
         $this->Write(14, "  NO");
      }

      $this->SetTextColor(0,0,0);
      $this->Ln(16);

      // Get the old margin
      $oldMargin = $this->lMargin;

      $footnoteStartMargin = $oldMargin+20;
      $footnoteMidMargin   = $oldMargin+40;

      $this->SetFontSize(9);

      foreach($notesArray["footNotes"] as $fn)
      {
         $this->SetFont("","");
         $this->SetLeftMargin($footnoteStartMargin);
         $this->Write(9, $this->footnoteCounter . " - ");
         $this->SetLeftMargin($footnoteMidMargin);
         $this->Write(9, $fn);
         $this->SetLeftMargin($footnoteStartMargin);
         $this->Ln();
         $this->Ln();
         $this->footnoteCounter++;
      }

      $this->SetLeftMargin($oldMargin);
      $this->Ln();
      $this->Ln();
   }
}
?>