<?php
/************************************************************************
 * FILE:   mainStyles.css.php                                           *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file contains the CSS used in the Fair Use Application.         *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - "includes/browserCheck.php"                                     *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - None                                                            *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - Rather than using CSS hacks to accomodate browser-specific      *
 *      styles, we use conditional statements in PHP.                   *
 *    - Because the file extension for this file is .php, we include    *
 *      a call to the header function to send the appropriate content   *
 *      type to browsers.                                               *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

// Include browser check file
include("../includes/browserCheck.php");
header("Content-type: text/css; charset=iso-8859-1");

?>

/******************************************************
 * We begin by applying some universal styles to the  *
 * body.                                              *
 ******************************************************/
body
{
   padding:0;
   margin:1% auto;
   font-family:Helvetica,Calibri,Verdana,Arial,sans-serif,serif;
}

/******************************************************
 * The following styles are for the gray box in which *
 * all content is contained, with the exception of    *
 * the footer.                                        *
 ******************************************************/
#contentWrapper
{
   margin:auto;
   width:80%;
   background-color:#ebe9df;
   border:1px solid #ddd;
   background-image:url('../images/bgGears.gif');
   background-position:100% 100%;
   background-repeat:no-repeat;
}

/******************************************************
 * The following styles are only applied to the front *
 * page.                                              *
 ******************************************************/
#frontWrapper
{
   margin:auto;
   width:80%;
   background-color:#ebe9df;
   border:1px solid #ddd;
   padding:1% 1% 0 1%;
}

#frontWrapper h1
{
   background-image:url('../images/frontGears.gif');
   background-position:50px 0%;
   background-repeat:no-repeat;
   padding-left:225px;
   font-size:106px;
   line-height:70px;
   font-size:86px;
   color:#000082;
   margin:0;
   padding-top:20px;
   font-weight:normal;
}

#frontWrapper h2
{
   font-size:20px;
   color:#c00;
}

#frontLeftCol
{
   float:left;
   width:50%;
   margin-left:4%;
   margin-bottom:0;
}

#frontLeftCol li
{
   font-size:95%;
}

.frontButtonsContainer
{
   float:right;
   width:40%;
   height:50%;
   padding:0;
   font-size:120%;
}

#frontWrapper .frontButtonsContainer
{
   padding:4% 2% 3% 2%;
}

#frontWrapper .frontButtonsContainer a
{
   display:block;
   width:40%;
   padding:5% 10%;
   margin:10%;
   background-color:#adaabd;
   background-image:url("../images/checkBg.png");
   background-repeat:no-repeat;
   background-position:5px 0;
   text-align:center;
   color:white;
   text-decoration:none;
}


.frontButtonsContainer a
{
   display:block;
   width:50%;
   padding:5% 5%;
   margin:6%;
   background-color:#adaabd;
   background-image:url("../images/checkBg.png");
   background-repeat:no-repeat;
   background-position:5px 0;
   text-align:center;
   color:white;
   text-decoration:none;
}

.frontButtonsContainer a:hover
{
   color:#c00;
}

.frontButtonsContainer label
{
   display:block;
   width:50%;
   padding:5% 5%;
   margin:6%;
   background-color:#adaabd;
   background-image:url("../images/checkBg.png");
   background-repeat:no-repeat;
   background-position:5px 0;
   text-align:center;
   color:white;
   border:0;
}

#frontWrapper .frontButtonsContainer label
{
   display:block;
   width:40%;
   padding:5% 10%;
   margin:10%;
   background-color:#adaabd;
   background-image:url("../images/checkBg.png");
   background-repeat:no-repeat;
   background-position:5px 0;
   text-align:center;
   color:white;
   border:0;
}

.frontButtonsContainer label:hover
{
   color:#c00;
}

.frontButtonsContainer input
{
   display:none;
}

/******************************************************
 * The following styles are applied to the header and *
 * provide for the logo/title.                        *
 ******************************************************/
#header
{
   height:42px;
   background-image:url('../images/logo_sm.gif');
   background-repeat:no-repeat;
   margin:11px 17px;
   /* padding-left:52px; */
   padding-bottom:11px;
   border-bottom:1px solid #69c;
}

#header h1, #header h1 a
{
   font-size:19px;
   color:#000082;
   margin:0;
   font-weight:normal;
   text-decoration:none;
}

/******************************************************
 * The following styles are used for the completion   *
 * bar that appears in the upper right-hand corner on *
 * every page.                                        *
 ******************************************************/
#completionDiv
{
   height:10px;
   float:right;
   margin-bottom:-10px;
}

#completionDiv .textual
{
   float:right;
   line-height:10px;
   font-size:8pt;
   font-family:arial,sans serif;
   color:#c00;
   padding-left:4px;
   width:90px;
}

#completionBar
{
   float:right;
   width:100px;
   height:10px;
   border:1px solid #666;
}

#completionBar span
{
   background-color:#c00;
   height:10px;
   display:block;
   font-size:1px;
}

/******************************************************
 * The following styles are applied to the main text  *
 * on all but the first page of the application.      *
 ******************************************************/

#content
{
   display:block;

}

#content h2
{
   text-align:center;
   color:#000082;
   font-size:40px;
   margin:0;
   margin-bottom:-20px;
   line-height:60px;
}

#content h2 span
{
   font-size:68px;
   font-weight:normal;
}

#content h2 a
{
   font-size:16px;
   font-weight:normal;
}

#content h2 a.noShow
{
   font-size:16px;
   font-weight:normal;
   visibility:hidden;
}

/******************************************************
 * The following styles are used for the two column   *
 * layout found on some pages within the application. *
 ******************************************************/
.twoColumnBoxWrapper
{
   background-image:url("../images/opaque.png");
   margin:2% 5%;
}

/* NOTE: Added a background color to account for IE 6 funkiness.*/
.twoColumnBox
{
   background-image:url("../images/columnSeparator.gif");
   background-repeat:repeat-y;
   background-position:50% 0;
   <?php
      if($ie && ((float) $browserVersion) < 7)
         echo "background-color:#ebe9df;";
   ?>
}

.col1
{
   float:left;
}

.col2
{
   float:right;
}


.twoColumn
{
   width:46%;
   padding:1%;
}
/******************************************************
 * The following styles are applied to the back/next  *
 * links at the top of each page.                     *
 ******************************************************/

/* LEGACY CODE - DO NOT REMOVE */
#controls
{
   visibility:hidden;
   float:right;
   padding:2px;
}

#controlsTop
{
   float:right;
   padding:2px;
}

#controlsTop a, #controlsTop input
{
   color:#7f7f7f;
   text-decoration:none;
   font-size:19px;
   line-height:19px;
   background-color:transparent;
   border:0;
}

#backLinkTop
{
   padding:0 10px 0 15px;
   border-right:1px solid #7f7f7f;
   background-image:url("../images/backArrow.gif");
   background-repeat:no-repeat;
   background-position:0% 0%;
}

input#backLinkTop
{
   <?php if($ie) {?>
   background-position:0% 0px;
   <?php } else {?>
   background-position:0% 2px;
   <?php } ?>
   height:21px;
   line-height:19px;
   font-size:19px;
   <?php if($ie) {?>
   padding:0 5px 0 5px;
   <?php } ?>
}

#controlsTop a#backLinkTop, #controlsTop a#nextLinkTop
{
   position:relative;
   top:<?php if(!$ie) echo 4; else echo 10; ?>px;
   font-size:<?php if(!$ie) echo 20; else echo 19; ?>px;
}


a#backLinkTop
{
<?php if(!$ie) {?>
   padding-right:18px;
<?php } else { ?>
   padding-right:18px;
<?php } ?>
}


#backLinkTop:hover
{
   background-position:0% -31px;
   color:#c00;
}

input#backLinkTop:hover
{
   <?php if($ie) {?>
   background-position:0% -31px;
   <?php } else {?>
   background-position:0% -29px;
   <?php } ?>

   color:#c00;
}

#nextLinkTop
{
   padding:0 15px 0 10px;
   background-image:url("../images/nextArrow.gif");
   background-repeat:no-repeat;
   background-position:100% 0%;
}

<?php if(!$ie) {?>
a#nextLinkTop
{
   background-position:100% 0px;
}
<?php } ?>

input#nextLinkTop
{
   <?php if(!$ie) { ?>
   background-position:100% 2px;
   <?php } else { ?>
   background-position:100% 0;
   <?php }?>
   height:21px;
   line-height:19px;
   font-size:19px;
   <?php
   if($browser = "opera")
      echo "   cursor:pointer !important;\n";
   else
      echo "   cursor:pointer;\n";
   ?>
   <?php if($ie) {?>
   padding:0 10px 0 0;
   <?php } ?>

}

#nextLinkTop:hover
{
   background-position:100% -31px;
   color:#c00;
}

input#nextLinkTop:hover
{
   <?php if(!$ie) { ?>
   background-position:100% -29px;
   <?php } else { ?>
   background-position:100% -31px;
   <?php }?>

}

/******************************************************
 * The following styles are applied to the footer     *
 * which contains the informational links at the      *
 * bottom of each page.                               *
 ******************************************************/
#footer, #localInfo
{
   margin:auto;
   width:80%;
   text-align:right;
   color:#00c;
   font-family:Geneva,Helvetica,Calibri,Verdana,Arial,sans-serif,serif;
   font-size:11px;
}

#footer a, #localInfo a
{
   text-decoration:none;
   color:#00c;
}

#footer a:hover, #localInfo a:hover
{
   text-decoration:underline;
   color:#c00;
}

#footer img
{
   border:0;
   padding:5px 5px 0 5px;
   float:right;
}

/* This is the div that holds the links in the footer */
#footer div
{
   float:right;
   padding-top:5px;
}

/******************************************************
 * The following general styles are used throughout   *
 * the application.                                   *
 ******************************************************/
.clearBlock
{
   clear:both;
}

.underlined
{
   text-decoration:underline;
}

a.smallLink
{
   font-size:11px;
}

li
{
   font-size:15.5px;
}

li.boldBullet
{
   font-weight:bold;
   font-size:18px;
}

li.boldBullet li
{
   font-weight:normal;
   font-size:15px;
}

li li
{
   margin:10px auto;
}

li
{
   list-style: square;
   list-style-image:url('../images/bullet.gif');
}

ul li
{
   margin: .3em 0 .3em 0
}

ol li
{
   list-style-image:none;
   list-style:decimal;
}

ol.roman li
{
   list-style-image:none;
   list-style-type:lower-roman;
   color:#c00;
}

ol.roman li span
{
   color:black;
}


.singleCol
{
   padding:2% 5%;
}

.finalPage .singleCol
{
   padding:1% 5% 0 5%;
}

table
{
   width:90%;
}

th
{
   text-align:right;
   font-weight:normal;
   font-size:13px;
   width:14%;
}

th.labelCell
{
   width:30%;
   font-size:15px;
}

td input
{
   width:<?php
   if($ie)
      echo "98";
   else
      echo "100";
   ?>%;
   background-color:#dce6f2;
   border:1px solid #385d8a;
   height:19px;
   padding:3px;
   line-height:20px;
   color:#000082;
}

textarea
{
   width:<?php
   if($ie)
      echo "98";
   else
      echo "100";
   ?>%;
   background-color:#dce6f2;
   border:1px solid #385d8a;
   height:100px;
   color:#000082;
   overflow:auto;
   font-family:Helvetica,Calibri,Verdana,Arial,sans-serif,serif;
   font-size:12px;
   padding:3px;

}

td textarea
{
   width:<?php
   if($ie)
      echo "98";
   else
      echo "100";
   ?>%;
   height:37px;
}

td div, #innerScale td div
{
   background-color:#dce6f2;
   height:20px;
   width:20px;
   border:1px solid #385d8a;
   overflow:hidden;
   background-image:url("../images/check.png");
   background-repeat:no-repeat;
   background-position:-21px -21px;
}

#innerScale td div
{
   padding:2px;
}

#innerScale td div:hover
{
   padding:0;
   border-width:3px;
   border-color:#00c;
}


td div input.checkbox
{
   width:50px;
   height:50px;
   padding:0;
   margin:0;
   margin-left:-15px;
   margin-top:-1<?php if($ie) echo 6; else echo 5; ?>px;
}

.footnote
{
   font-size:80%;
   font-style:italic;
}

/******************************************************
 * The following general styles are used for the      *
 * scales used throughout the application.            *
 ******************************************************/
.slidingScale
{
   text-align:center;
   padding:10px 5%;
   width:90%;
}

.slidingScale table
{
   margin:0 auto;
   width:90%;
}

.slidingScale th
{
   font-weight:bold;
}

.slidingScale table td
{
   text-align:center;
}

.slidingScale td
{
   width:14%;
   text-align:center;
}


.slidingScale th.scaleImage
{
   background-image:url("../images/scaleBase.gif");
   background-repeat:no-repeat;
   background-position:50% 50%;
   width:79%;
}

.fairLabel
{
   width:10%;
   padding:0;
   text-align:left;
}

.unfairLabel
{
   width:10%;
   padding:0;
   text-align:right;
}

.leftArrow
{
   padding-top:1px;
   float:left;
}

.rightArrow
{
   float:right;
   padding-top:1px;
}

.slidingScale td div
{
   display:block;
   width:100%;
   text-align:center;
   background-color:transparent;
   border:0;
   height:30px;
}

#innerScale td
{
   text-align:center;
}

#innerScale td div
{
   margin:0 auto;
}

#innerScale td.fair1 div
{
   background-color:#006;
}

#innerScale td.fair2 div
{
   background-color:#33f;
}

#innerScale td.fair3 div
{
   background-color:#36f;
}

#innerScale td.fair4 div
{
   background-color:#69f;
}

#innerScale td.fair5 div
{
   background-color:#9cf;
}

#innerScale td.fair6 div
{
   background-color:#ccecff;
}

#innerScale td.fair7 div
{
   background-color:#ebf7ff;
}

/***************************
 * Used for inactive links *
 ***************************/
.noLink
{
   visibility:hidden;
}

.noBullet
{
   list-style:none;
}


/*********************************
 * Used on the last page         *
 *   for the AJAX functionality. *
 *********************************/
#jsButton
{
   display:none;
}

/*
 * Used to hide some bullets to allow
 * for lists to start on any given
 * bullet number.
 */
.hideBullet
{
   visibility:hidden;
   padding:0;
   margin:0;
   margin-top:-5px;
   height:1px;
   <?php
   if($ie)
   {
   ?>
   margin-top:-32px;
   <?php
   }
   ?>
}


/*
 * Used for paragraphs in the educational portion
 * of the application.
 */
p.descriptiveText
{
   padding:0 20%;
   <?php
   if($ie)
   {
   ?>
   padding-bottom:2%;
   <?php
   }
   ?>
}


























/******************************************************
 * The following styles are used for the resizable    *
 * textarea handles.                                  *
 ******************************************************/
.resizeGrip
{
   height:8px;
   background-color:#385D8A;
   background-image:url("../images/resizeGrip.png");
   background-repeat:no-repeat;
   background-position:50% 50%;
   display:none;
   <?php
   // Opera doesn't like the ns-resize cursor for some reason.
   if($browser = "opera")
      echo "   cursor:move;\n";
   else
      echo "   cursor:ns-resize;\n";
   ?>
   width:<?php
   if($ie)
      echo "99";
   else
      echo "101";
   ?>%;
   /* margin-right:-8px; */
}
