<?php
/************************************************************************
 * FILE:   footer.php                                                   *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file is used to maintain a consistent footer on the bottom of   *
 * every page in the application.                                       *
 *                                                                      *
 * CLASSES USED:                                                        *
 *    - None                                                            *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - "includes/properties.php"                                       *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - None                                                            *
 *                                                                      *
 * JAVASCRIPT:                                                          *
 *    - None                                                            *
 *                                                                      *
 * STYLE SHEETS:                                                        *
 *    - None                                                            *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - None                                                            *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

   include_once($path."includes/properties.php");

   // Used for non-Javascript users.
   if(isset($_GET["backLink"]))
   {
      echo "   <div id=\"controls\">\n";
      echo "      <a href=\"".$_GET["backLink"]."\" id=\"backLink\">Back</a>\n";
      echo "   </div>";
      echo "   <div class=\"clearBlock\"></div>";
      echo "</div>";
   }
   // Used for the evaluation tool pages.
   else if(($thisPage = array_search($currentFile, $evaluationToolPages)) !== false)
   {
      echo "<div id=\"controls\">\n";

      if(isset($evaluationToolPages[($thisPage-1)]))
      {
         echo "      <input type=\"hidden\" name=\"prevPage\"  id=\"prevPage\" value=\"".$evaluationToolPages[($thisPage-1)]."\" />\n";
         echo "      <a href=\"".$evaluationToolPages[($thisPage-1)]."\" id=\"backLink\">Back</a>\n";
      }
      else if($currentFile == $evaluationToolPages[$thisPage])
      {
         echo "      <input type=\"hidden\" name=\"prevPage\"  id=\"prevPage\" value=\"index.php\" />\n";
         echo "      <a href=\"index.php\" id=\"backLink\">Back</a>\n";
      }
      else
         echo "      <a href=\"#\" id=\"backLink\" class=\"noLink\">Back</a>\n";

      if(isset($evaluationToolPages[($thisPage+1)]))
         echo "      <input type=\"submit\" name=\"nextLink\" value=\"Next\" id=\"nextLink\" />\n";
      else
         echo "      <a href=\"#\" id=\"nextLink\" class=\"noLink\">Next</a><br />\n";

      echo "   </div>";
      echo "   </form>\n";

      echo "   <div class=\"clearBlock\"></div>";
      echo "</div>";
   }
   // Used for the educational pages.
   else if(($thisPage = array_search($currentFile, $educationalPages)) !== false)
   {
      echo "   <div id=\"controls\">\n";
      if(isset($educationalPages[($thisPage-1)]))
         echo "      <a href=\"".$educationalPages[($thisPage-1)]."\" id=\"backLink\">Back</a>\n";
      else if($currentFile == $educationalPages[$thisPage])
         echo "      <a href=\"index.php\" id=\"backLink\">Back</a>\n";
      else
         echo "      <a href=\"#\" id=\"backLink\" class=\"noLink\">Back</a>\n";

      if(isset($educationalPages[($thisPage+1)]))
         echo "      <a href=\"".$educationalPages[($thisPage+1)]."\" id=\"nextLink\">Next</a>\n";
      else
         echo "      <a href=\"#\" id=\"nextLink\" class=\"noLink\">Next</a>\n";
      echo "   </div>";
      echo "   <div class=\"clearBlock\"></div>";
      //echo "</div>";
   }
   ?>
   </div>
   <div id="footer">
      <a href="http://creativecommons.org/licenses/by-nc-sa/3.0/" onclick="newWindowLink(this); return false;"><img src="images/cc1.png" alt="Creative Commons, Some Rights Reserved" /></a>
      <div>
      <?php
      echo "<span id=\"localInfo\"><a href=\"localcopyrightinfo.php?backLink=".urlencode($_SERVER["PHP_SELF"])."\">Local Copyright Information</a></span><br />";
      ?>
      &copy; 2008 <a href="mailto:brewerm@u.library.arizona.edu<?php if(strstr($_SERVER['HTTP_USER_AGENT'],"Windows") !== false) echo "&amp;Subject=Fair Use Evaluator"; ?>">Michael Brewer</a> &amp; <a href="mailto:crussell@alawash.org<?php if(strstr($_SERVER['HTTP_USER_AGENT'],"Windows") !== false) echo "&amp;Subject=Fair Use Evaluator"; ?>">ALA Office for Information Technology Policy</a></div>
   </div>
   
<script src="http://www.google-analytics.com/urchin.js" type="text/javascript">
</script>
<script type="text/javascript">
_uacct = "UA-2316500-2";
urchinTracker();
</script>

</body>
</html>