/************************************************************************
 * FILE:   textarea.js                                                  *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file contains the JavaScript that allows users to resize        *
 * textareas within the application.                                    *
 *                                                                      *
 * GLOBAL VARIABLES:                                                    *
 *    - staticOffset - Used to store how far from the top of the page   *
 *                     the textarea originally is.                      *
 *                                                                      *
 *    - textarea     - Used to store the textarea being resized.        *
 *                                                                      *
 *    - resizeGrip   - Used to store the element being used as the      *
 *                     resize handle.                                   *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - initResize  - Initializes the textarea resize functionality.    *
 *                                                                      *
 *    - startDrag   - Begins the resizing process for the textarea.     *
 *                    Also assigns the onmousemove and onmouseup        *
 *                    events.                                           *
 *                                                                      *
 *    - performDrag - Continues resizing process for the textarea.      *
 *                                                                      *
 *    - endDrag     - Ends the resizing process for the textarea. Also  *
 *                    clears the onmousemove and onmouseup events.      *
 *                                                                      *
 *    - parseSize   - Parses the integer value of the string passed to  *
 *                    the function (in the form ___px).                 *
 *                                                                      *
 *    - makeOpaque  - Changes the opacity of the element to the value   *
 *                    passed into the function.                         *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - In order to use this script, be sure to add the following       *
 *      attributes to your <body> tag:                                  *
 *           onload="initResize( elementID )"                           *
 *      where elementID is the id attribute for the textarea being      *
 *      resized.                                                        *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/


// Global variables
var staticOffset;
var textarea;
var resizeGrip;

/*********************************************************
 * FUNCTION: initResize                                  *
 *                                                       *
 * PURPOSE: Initializes the textarea resize              *
 *          functionality.                               *
 *                                                       *
 * PARAMETERS:  - tID - The id attribute of the textarea *
 *                      that will be resized.            *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function initResize(tID)
{
   textarea = document.getElementById(tID);
   if(textarea.style.height == "")
      textarea.style.height = "100px";
      
   resizeGrip = document.getElementById("resizeGrip");
   resizeGrip.onmousedown = startDrag;
   resizeGrip.style.display = "block";
}

/*********************************************************
 * FUNCTION: startDrag                                   *
 *                                                       *
 * PURPOSE: Begins the resizing process for the          *
 *          textarea. Also assigns the onmousemove and   *
 *          onmouseup events.                            *
 *                                                       *
 * PARAMETERS:  - e - The mouse click event              *
 *                                                       *
 * RETURNS: Returns boolean false on success (to         *
 *          override the mouse click event).             *
 *                                                       *
 *********************************************************/
function startDrag(e)
{
   if(!e)
   {
      if(window.event)
      {
         e = window.event;
      }
      else
      {
         return;
      }
   }
   
   if(ie)
      staticOffset = parseSize(textarea.style.height) - e.clientY;
   else
      staticOffset = parseSize(textarea.style.height) - e.pageY;
   //textarea.css('opacity', 0.25);

   makeOpaque(resizeGrip, 25);
   
   document.onmousemove = performDrag;
   document.onmouseup = endDrag;

   return false;
}

/*********************************************************
 * FUNCTION: performDrag                                 *
 *                                                       *
 * PURPOSE: Continues resizing process for the textarea. *
 *                                                       *
 * PARAMETERS:  - e - The mouse move event               *
 *                                                       *
 * RETURNS: Returns boolean false on success (to         *
 *          override the mouse click event).             *
 *                                                       *
 *********************************************************/
function performDrag(e)
{
   if(!e)
   {
      if(window.event)
      {
         e = window.event;
      }
      else
      {
         return;
      }
   }

   if(ie)
      textarea.style.height = (Math.max(32, staticOffset + e.clientY) + 'px');
   else
      textarea.style.height = (Math.max(32, staticOffset + e.pageY) + 'px');
   return false;
}

/*********************************************************
 * FUNCTION: endDrag                                     *
 *                                                       *
 * PURPOSE: Ends the resizing process for the textarea.  *
 *          Also clears the onmousemove and onmouseup    *
 *          events.                                      *
 *                                                       *
 * PARAMETERS:  - e - The mouse up event                 *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function endDrag(e)
{
   document.onmousemove = "";
   document.onmouseup = "";
   
   makeOpaque(resizeGrip, 100);
   return;
}

/*********************************************************
 * FUNCTION: parseSize                                   *
 *                                                       *
 * PURPOSE: Parses the integer value of the string       *
 *          passed to the function (in the form ___px).  *
 *                                                       *
 * PARAMETERS:  - val - The string value to be parsed    *
 *                                                       *
 * RETURNS: The integer value of the string passed in.   *
 *                                                       *
 *********************************************************/
function parseSize(val)
{
   return val.substring(0,val.length-2);
}

/*********************************************************
 * FUNCTION: makeOpaque                                  *
 *                                                       *
 * PURPOSE: Changes the opacity of the element to the    *
 *          value passed into the function.              *
 *                                                       *
 * PARAMETERS:  - el      - The element being faded      *
 *                                                       *
 *              - opacity - The new opacity value for    *
 *                          the element.                 *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function makeOpaque(el, opacity)
{
   el.style.opacity = (opacity / 100);
   el.style.MozOpacity = (opacity / 100);
   el.style.KhtmlOpacity = (opacity / 100);
   el.style.filter = "alpha(opacity=" + opacity + ")";
}