<?php
/************************************************************************
 * FILE:   popUp.php                                                    *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file is used to get the content of files from the educational   *
 * portion of the tool via AJAX calls. The file also does some dynamic  *
 * modification of the code where necessary.                            *
 *                                                                      *
 * CLASSES USED:                                                        *
 *    - None                                                            *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - None                                                            *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - None                                                            *
 *                                                                      *
 * JAVASCRIPT:                                                          *
 *    - None                                                            *
 *                                                                      *
 * STYLE SHEETS:                                                        *
 *    - None                                                            *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - None                                                            *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

// Array containing files that need to have bullets tagged with
// the onclick value of 'updateTextarea'.
$stripBullets = array("purposedescription.php",
                      "amountdescription.php",
                      "effectdescription.php",
                      "naturedescription.php");


// If the filename is not specified, then we simply return
// the value "Content not available."
if(isset($_GET["content"]))
{
   $fileName = $_GET["content"];

   // If the filename requested does not exist, then we simply
   // return the value "Content not available."
   if(file_exists($fileName))
   {
      // Get file contents
      $popUpContent = file_get_contents($fileName);

      // Get rid of extra white space
      $order   = array("\r\n", "\n", "\r");
      $popUpContent = str_replace($order, "", $popUpContent);
      $popUpContent = preg_replace("/\s+/", " ", $popUpContent);

      // If the file needs to have onclick values assigned to
      // bullets, then we do it here.
      if(in_array($fileName, $stripBullets))
      {
         while(preg_match("/(\<li[^\>]*>)([^\<]*)(\")(.*?)(\<\/li\>)/", $popUpContent))
         {
            $popUpContent = preg_replace("/(\<li[^\>]*>)([^\<]*)(\")(.*?)(\<\/li\>)/", "$1$2&#34;$4$5", $popUpContent);
         }

         $popUpContent = preg_replace("/(\<li\>(.*?))\<\/li\>/m", "$1 - <a href=\"#\" onclick=\"javascript: updateTextarea('$2',this); return false;\">Paste in Text</a></li>", $popUpContent);
         $popUpContent = str_replace("</p>", " Clicking \"paste in text\" will insert those criteria into your Fair Use Evaluation. Once you've inserted them, you'll be able to go back and modify or expand on them as you see fit.*</p>", $popUpContent);
         $popUpContent .= "<p>*DISCLAIMER: Other than where direct quotes are used, none of these examples come directly from the law, as it is written in Section 107. The language and concepts in some of the examples are derived from court decisions on fair use or come from fair use guidelines or checklists that have been developed to help people apply the law and/or avoid lawsuits.  These examples are only intended to help users better understand some of the criteria or approaches others have used in weighing the four factors. The fact that more criteria may favor a use than oppose it, is not necessarily determinative of its fairness, as some criteria may weigh more heavily for or against than others.</p>";
      }

      // Strip out all PHP tags.
      echo preg_replace("/\<\?php(.*?)\?\>/s", "", $popUpContent);
   }
   else
      echo "<p><em>Content not available.</em></p>";

}
else
{
   echo "<p><em>Content not available.</em></p>";
}
?>