<?php
   include("../includes/browserCheck.php");
   header("Content-type: text/css; charset=iso-8859-1");
?>

/******************************************************
 * We begin by applying some universal styles to the  *
 * body.                                              *
 ******************************************************/
body
{
   padding:0;
   margin:0;
   font-family:Calibri,Helvetica,Verdana,Arial,sans-serif,serif;
   padding:0 10%;
}

img
{
   padding:0;
   margin:0;
   border:0;
}

a
{
   /*color:#00f;*/
   color:#5e5eff;
   padding:0 1%;
}

#contentWrapper
{
   margin:2% auto;
   background-image:url("../images/sm_chalkboard.jpg");
   background-image:linear-gradient(rgba(0,0,0,.5) 0%, rgba(0,0,0,.5) 100%), url("../images/sm_chalkboard.jpg");
   background-position:50% 0;
   background-repeat:no-repeat;
   color:white;
   background-color:#000;
   font-size:130%;
   min-height:600px;
   max-width: 1266px;
}


#contentWrapper h1
{
   margin:0;
   padding:0;
   background-image:url("../images/sm_scale2.png");
   background-repeat:no-repeat;
   background-position:0 20px;
   margin:0 2%;
   padding-top:20px;
   margin-bottom:-20px;
   min-height:110px;
   text-align:center;
   font-size:50px;
   font-weight:normal;
}

#contentWrapper h1 img
{
   float:left;
   width:110px;height:100px;
}

#contentWrapper h1 a
{
   color:white;
   text-decoration:none;
   border:0;
}


#contentWrapper h1 span
{
   font-size:36px;
   display:block;
   color:#bfbfbf;
}

.frontWrapper
{
   padding:5%;
   margin-top:2%;
   background-image:url("../images/sm_scales.png");
   background-position:50% 15%;
   background-repeat:no-repeat;
}

#contentWrapper h1
{
   margin-bottom:4%;
}

#contentWrapper .frontWrapper h1
{
   font-size:70px;
   text-align:center;
   font-weight:normal;
   background-image:none;
   min-height:0;
   padding:0;
   padding-top:60px;
   min-height:1px;
}

#contentWrapper .frontWrapper h1 span
{
   font-size:42px;
   display:block;
   color:#bfbfbf;
}

#contentWrapper .frontWrapper h1 a.smallLink
{
   color:yellow;
   position:relative;
   top:-20px;
   padding:0;
}

#contentWrapper .frontWrapper h1 a.noLink
{
   position:relative;
   top:-10px;
}

#contentWrapper .frontWrapper p#enterLink
{
   width:100%;
   margin:0 0 0 0;
   text-align:center;
}

/*
.questionText      { }
.answerOptions     { }
.endLinks          { }

.metRequirements   { padding-left: 100px; }
.unmetRequirements { padding-left: 100px;}
.crossOutSymbol    { min-height:100px;background-image:url("../images/crossOut.png"); background-repeat:no-repeat; }
.starSymbol        { background-image:url("../images/star.png"); background-repeat:no-repeat; }
*/

/*
.questionText, .metRequirements, .unmetRequirements
{
   padding-left: 85px;
}
*/

/* Covers the "Start Over" and "Create Custom PDF" links */
.answerOptions
{
   display:inline;
   padding:0;
   margin:0;
}

.answerOptions a
{
   padding:0 10px;
   border:2px solid white;
   border-width:0 2px;
   margin-right:-2px;

}

/* Covers the "Start Over" and "Create Custom PDF" links */
.endLinks
{
   text-align:center;
   padding:2% 0;
   font-size:140%;
}

.endLinks input
{
   text-align:center;
   position:relative;
   padding-bottom:0;
   border:0;
   background-color:transparent;
   color:#00f;
   font-size:90%;
   border-left:3px solid white;
   padding-left:15px;
   margin-left:10px;
   margin-bottom:0;
   cursor:pointer;
   <?php if($ie) {?>
   margin-top:0px;
   <?php } ?>
}

.endLinks a#finalStartOver
{
   text-decoration:none;
   <?php if($ie) { ?>
   margin-top:-100px;
   padding-bottom:5px;
   padding-right:50px;
   font-size:110%;
   <?php } ?>
}

.crossOutSymbol    { min-height:65px;background-image:url("../images/sm_crossOut.png"); background-repeat:no-repeat; background-position:5px 0; }
.starSymbol        { min-height:65px;background-image:url("../images/sm_star.png"); background-repeat:no-repeat; }


/******************************************************
 * The following styles are for the gray box in which *
 * all content is contained, with the exception of    *
 * the footer.                                        *
 ******************************************************/
#contentWrapper
{
   text-align:center;
}


#contentWrapper div.questionText,
#contentWrapper div.metRequirements,
#contentWrapper div.unmetRequirements,
#contentWrapper p,
#contentWrapper ul,
#contentWrapper ol
{
   width:75%;
   margin-left:auto;
   margin-right:auto;
   text-align:left;
   padding:0 85px 10px 85px;
}

#contentWrapper ul li, #contentWrapper ol li
{
   margin:2% 5%;
   padding:0 10px;
}

#contentWrapper ul.lessMargin li, #contentWrapper ol.noMargin li
{
   margin:0% 5%;
   padding:0 10px;
}

#contentWrapper .frontWrapper div, #contentWrapper .frontWrapper p
{
   width:100%;
   margin-left:0;
   margin-right:0;
   margin-bottom:2%;
   padding:0;
}

/******************************************************
 * The following styles are applied to the header and *
 * provide for the logo/title.                        *
 ******************************************************/
#header
{

}

/******************************************************
 * The following styles are applied to the footer     *
 * which contains the informational links at the      *
 * bottom of each page.                               *
 ******************************************************/
#footer, #localInfo
{
   margin:auto;
   width:100%;
   text-align:right;
   color:#00c;
   font-family:Geneva,Helvetica,Calibri,Verdana,Arial,sans-serif,serif;
   font-size:11px;
   padding-top:5px;
}



#footer a, #localInfo a
{
   text-decoration:none;
   color:#00c;
   padding:0;

}

#footer a:hover, #localInfo a:hover
{
   text-decoration:underline;
   color:#c00;
}

#footer img
{
   border:0;
   padding:0 5px;
   float:right;
}


/******************************************************
 * The following general styles are used throughout   *
 * the application.                                   *
 ******************************************************/
.clearBlock
{
   clear:both;
}

.underlined
{
   text-decoration:underline;
}

a.smallLink
{
   color:yellow;
   font-size:11px;
   border:0;
   padding:0;
   position:relative;
   top:-5px;
}

a.bigLink
{
   color:yellow;
   font-size:48px;
   padding:0 15px;
   border:2px solid white;
   border-width:0 3px;
}

.footnote
{
   font-size:80%;
   font-style:italic;
}

/***************************
 * Used for inactive links *
 ***************************/
.noLink
{
   visibility:hidden;
}

#contentWrapper li.noBullet
{
   margin:-1% 5%;
   list-style:none;
   padding-left:10%;
}

.textCenter,
#contentWrapper div.textCenter,
#contentWrapper p.textCenter
{
   text-align:center;
}


/**
 Form stuff...
**/
form table
{
   width:75%;
   margin-bottom:2%;
}

form table th
{
   font-weight:normal;
   text-align:right;
   font-size:85%;
   <?php if($ie) echo "width:30%;";?>
}

form table td
{
   text-align:left;
}

form table td input
{
   width:100%;
   border:0;
}

form table td input.checkboxRadio
{
   width:auto;
   min-width:15px;
   min-height:15px;
   margin-right:5%;
}

form table td div
{
   display:block;
   float:left;
   width:<?php if($ie) echo "25"; else echo "40"?>%;

}

form table td div
{
   height:20px;
   overflow:hidden;
   background-image:url("../images/check.png");
   background-repeat:no-repeat;
   background-position:0 -27px;
}

form table td div input.checkboxRadio
{
   margin-top:-1<?php if($ie) echo 6; else echo 5; ?>px;
}

.toolTipText
{
   display:none;
}

#WzTtDiV ul
{
   margin:0;
   padding:0;
   list-style:none;
}


.italic
{
   <?php if(!ie){ ?>
   font-style:italic;
   <?php } else { ?>
   font-style:bold;
   color:#333;
   <?php }?>
}