function Ajax(URL, callbackFunction)
{
   var that=this;
   this.working = false;
   this.returnType = "text";
   this.parsedArray = new Array();
   this.abort = function() {
      if (this.working)
      {
         that.working=false;
         that.AJAX.abort();
         that.AJAX=null;
      }
   }

   this.send = function(passData,postMethod)
   {
      if (that.working)
      {
         return false;
      }
      that.AJAX = null;
      if (window.XMLHttpRequest)
      {
         that.AJAX=new XMLHttpRequest();
      }
      else
      {
         that.AJAX=new ActiveXObject("Microsoft.XMLHTTP");
      }
      if (that.AJAX==null)
      {
         return false;
      }
      else
      {
         that.AJAX.onreadystatechange = function()
         {
            if (that.AJAX.readyState==4)
            {
               if(that.returnType == "array")
               {
                  // Parse array from results.
                  that.parsedArray = getParsedArray(that.AJAX.responseText);
                  that.callback(that.parsedArray,that.AJAX.status,that.AJAX.responseXML);
               }
               else
                  that.callback(that.AJAX.responseText,that.AJAX.status,that.AJAX.responseXML);
               that.working=false;
               that.AJAX=null;
            }
         }
         that.working = new Date();
         if (/post/i.test(postMethod))
         {
            var uri=urlCall+'?'+that.working.getTime();
            that.AJAX.open("POST", uri, true);
            that.AJAX.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            that.AJAX.send(passData);
         }
         else
         {
            var uri=urlCall+'?'+passData+'&timestamp='+(that.working.getTime());
            that.AJAX.open("GET", uri, true);
            that.AJAX.send(null);
         }
         return true;
      }
   }

   this.GetAssoc = function()
   {
      if(!that.working)
         alert("Getting assoc");
      else
         setTimeout(that.GetAssoc, 30);
   }

   var urlCall = URL;
   this.callback = callbackFunction || function () { };
}

function getParsedArray(urlString)
{
   // Set up return variable.
   var returnArray = new Array();
   
   // Break up more than one line
   var lines = urlString.split("\n");

   for(var a = 0; a < lines.length; a++)
   {
      returnArray[a] = getParsedLine(lines[a]);
   }
   
   return returnArray;
}

function getParsedLine(line)
{
   var returnArray = new Array();
   
   var parsed = line.split("&");

   for(var a = 0; a < parsed.length; a++)
   {
      var tmp = parsed[a].split("=");
      if(tmp.length > 1)
      {
         returnArray[a] = tmp[1];
         returnArray[tmp[0]] = tmp[1];
      }
      else
         returnArray[a] = tmp[0];
   }

   return returnArray;
}