<?php
$path = "../";
require($path."includes/sessionHandler.php");
require($path."includes/processPopUps.php");

require("class.pdf.php");

$popUpNotes = array();

// Get the pop-up notes content before we start...
foreach($popUpNotesText as $pageName=>$popUp)
{
   $pageName = trim(str_replace(".php-", "", str_replace(" ","",$pageName)));
   $popUpNotes[$pageName] = $popUp;
}

// Get additional information from the last form filled out...
if(isset($_POST["submit"]))
{
   $_SESSION["name"]         = $_POST["name"];
   $_SESSION["jobTitle"]     = $_POST["jobTitle"];
   $_SESSION["institution"]  = $_POST["institution"];
   $_SESSION["title"]        = $_POST["title"];
   $_SESSION["author"]       = $_POST["author"];
   $_SESSION["dateOfUse"]    = $_POST["du"];
   $_SESSION["moreInfo"]     = $_POST["moreInfo"];
   $_SESSION["includeNotes"] = $_POST["includeNotes"];
}

// Set page format.
$pageFormat["pageOrientation"]   = "P";          // P, L
$pageFormat["unitOfMeasurement"] = "in";         // mm (default), pt, cm, in
$pageFormat["pageFormat"]        = "Letter";     // Letter, Legal, A4

// Set font format.
$defaultFont["family"] = "H";
$defaultFont["style"] = "";
$defaultFont["size"] = 12;

/************************************
 * DO NOT DELETE BELOW THIS LINE!!! *
 ************************************/

$applicationPages = array();
$applicationPages["legalCopy"] = "legalcopy.php";
$applicationPages["faceToFace"] = "facetoface.php";
$applicationPages["onlineInstruction"] = "onlineinstruction.php";
$applicationPages["allowedUsers"] = "allowedusers.php";
$applicationPages["primarilyInstruction"] = "primarilyinstructional.php";
$applicationPages["selectedByInstructor"] = "selectedbyinstructor.php";
$applicationPages["learningGoals"] = "learninggoals.php";
$applicationPages["comparableAmount"] = "comparableamount.php";
$applicationPages["reasonableAndLimited"] = "reasonableandlimited.php";
$applicationPages["digitalVideo"] = "digitalvideo.php";
$applicationPages["institutionalMeasures"] = "institutionalmeasures.php";
$applicationPages["exempt"] = "exempt.php";


$landingPages = array();
$landingPages["legalCopy"] = "nolegalcopy.php";
$landingPages["faceToFace"] = "yesfacetoface.php";
$landingPages["onlineInstruction"] = "noonlineinstruction.php";
$landingPages["allowedUsers"] = "noallowedusers.php";
$landingPages["primarilyInstruction"] = "notprimarilyinstructional.php";
$landingPages["selectedByInstructor"] = "notselectedbyinstructor.php";
$landingPages["learningGoals"] = "notlearninggoals.php";
$landingPages["comparableAmount"] = "notcomparableamount.php";
$landingPages["reasonableAndLimited"] = "notreasonableandlimited.php";
$landingPages["digitalVideo"] = "nodigitalvideo.php";
$landingPages["institutionalMeasures"] = "noinstitutionalmeasures.php";
$landingPages["exempt"] = "exempt.php";



//Instanciation of inherited class
$pdf=new PDF("P","pt","Letter");

$pdf->SetTitle("Exceptions for Instructors in U.S. Copyright Law");

$headerMargin = $pdf->lMargin;

// 50pt = .75in
$pdf->defaultMargin = 67;

$pdf->pageWidth = 567;


//$pdf->AliasNbPages("pgs");
$pdf->AddPage();
$pdf->SetFont('Helvetica');
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->SetFontSize(28);

$lineHeight = 28;

$pdf->Cell($page->pageWidth,$lineHeight,"     Exceptions for Instructors",0,1,"C");
$lineHeight = 28;
$pdf->SetTextColor(128,128,128);
$pdf->SetFontSize(15);
$pdf->Cell($page->pageWidth,$lineHeight,"in U.S. Copyright Law",0,1,"C");
$pdf->SetFontSize(9);
$lineHeight = 11;

$pdf->Ln(6);

$pdf->SetTextColor(64,64,64);



$pdf->Write($lineHeight, "Under certain conditions, U.S. Copyright Law provides for the educational use of copyrighted material");
$pdf->SetFont('', "I");
$pdf->Write($lineHeight, " without");
$pdf->SetFont('', "");
$pdf->Write($lineHeight, " the permission of the copyright holder.  To ensure your use meets all necessary conditions, it is recommended that you share this summary with a copyright specialist before proceeding with your intended use.");


$pdf->SetFillColor(0,0,255);
$pdf->SetDrawColor(0,0,255);

$pdf->DrawHR(1);

// Set font size and color
$lineHeight = 18;
$col2Start = 200;
$pdf->SetFillColor(220,220,220);
$pdf->SetDrawColor(220,220,220);


/*****************************
 *      USER INFORMATION     *
 *************************************************************************/
$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Name:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
// Need to adjust the margin in case of line breaks
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["name"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Job Title:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["jobTitle"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Institution:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["institution"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);


$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Title of Work Used:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["title"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);


$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Author/Copyright Holder:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["author"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Date of Use:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

$thisDate =  strtotime($_SESSION["dateOfUse"]);


if($thisDate != 0)
   $pdf->Write($lineHeight, date("F j, Y",$thisDate) );
else
{
   $pdf->SetFont('', "I");
   $pdf->Write($lineHeight, "");
   $pdf->SetFont('', "");
}

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Additional Information:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->MultiCell(0,$lineHeight-4,stripslashes($_SESSION["moreInfo"]));

$pdf->SetFillColor(0,0,255);
$pdf->SetDrawColor(0,0,255);

$pdf->DrawHR(1);

$pdf->SetFillColor(204,204,204);
$pdf->SetFont('', "B");
$pdf->SetFontSize(14);
$oldLineHeight = $lineHeight;
$lineHeight = 18;


// If we're legal...
if($_SESSION["meetsRequirements"])
{

   $imgIcon  = "../images/pdf_star.png";

   if($_SESSION["faceToFace"])
      $textDesc = "Your use appears to meet the requirements of Section 110 of U.S. Copyright Law, exempting it from requiring the permission of the copyright holder.*";
   else
      $textDesc = "Your use appears to meet the requirements of Section 110(2) of the U.S. Copyright Law (also known as the TEACH Act), exempting it from requiring the permission of the copyright holder.*";
}
// If we're not legal...
else
{
   $imgIcon  = "../images/pdf_crossout.png";
   $textDesc = "Your use does not meet the requirements of Section 110 or 110(2) of U.S. Copyright Law, exempting it from requiring the permission of the copyright holder.*";
}

$pdf->Cell(465,10, "", 0, 1, "C", true);

// Put in the image
$pdf->Cell(100,100, "", 0, 0, "C", true);
$stopY = $pdf->GetY() + 100;
$oldY = $pdf->GetY();
$oldX = $pdf->GetX();
$pdf->SetY($oldY+8);
$pdf->SetX($oldX - 85);
$pdf->Image($imgIcon);
$pdf->SetY($oldY);
$pdf->SetX($oldX);

// Put in the text
$pdf->MultiCell(365,$lineHeight, $textDesc, 0, "L", true);

$pdf->SetX(167);
$pdf->Cell(365,$lineHeight, "", 0, 1, "L", true);

//Get additional information
if(isset($_SESSION["legalCopy"]) && !$_SESSION["legalCopy"])
   $moreInfoFile = $landingPages["legalCopy"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) && $_SESSION["faceToFace"])
   unset($moreInfoFile);
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) && !$_SESSION["onlineInstruction"])
   $moreInfoFile = $landingPages["onlineInstruction"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) && !$_SESSION["allowedUsers"])
   $moreInfoFile = $landingPages["allowedUsers"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) && !$_SESSION["primarilyInstruction"])
   $moreInfoFile = $landingPages["primarilyInstruction"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) && !$_SESSION["selectedByInstructor"])
   $moreInfoFile = $landingPages["selectedByInstructor"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) &&
         isset($_SESSION["learningGoals"]) && !$_SESSION["learningGoals"])
   $moreInfoFile = $landingPages["learningGoals"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) &&
         isset($_SESSION["learningGoals"]) &&
         isset($_SESSION["comparableAmount"]) && !$_SESSION["comparableAmount"])
   $moreInfoFile = $landingPages["comparableAmount"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) &&
         isset($_SESSION["learningGoals"]) &&
         isset($_SESSION["comparableAmount"]) &&
         isset($_SESSION["reasonableAndLimited"]) && !$_SESSION["reasonableAndLimited"])
   $moreInfoFile = $landingPages["reasonableAndLimited"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) &&
         isset($_SESSION["learningGoals"]) &&
         isset($_SESSION["comparableAmount"]) &&
         isset($_SESSION["reasonableAndLimited"]) &&
         isset($_SESSION["digitalVideo"]) && !$_SESSION["digitalVideo"])
   $moreInfoFile = $landingPages["digitalVideo"];
else if (isset($_SESSION["legalCopy"]) &&
         isset($_SESSION["faceToFace"]) &&
         isset($_SESSION["onlineInstruction"]) &&
         isset($_SESSION["allowedUsers"]) &&
         isset($_SESSION["primarilyInstruction"]) &&
         isset($_SESSION["selectedByInstructor"]) &&
         isset($_SESSION["learningGoals"]) &&
         isset($_SESSION["comparableAmount"]) &&
         isset($_SESSION["reasonableAndLimited"]) &&
         isset($_SESSION["digitalVideo"]) &&
         isset($_SESSION["institutionalMeasures"]) && !$_SESSION["institutionalMeasures"])
   $moreInfoFile = $landingPages["institutionalMeasures"];

$pdf->SetFont('', "B");
$pdf->SetFontSize(11);
$lineHeight = 14;

if(isset($moreInfoFile))
{
   $additionalInfo = file_get_contents("../".$moreInfoFile);
   // Get rid of PHP tags
   // $file_contents = preg_replace("/\<\?php(.*?)\?\>/s", "", $file_contents);
   $order   = array("\r\n", "\n", "\r");
   $additionalInfo = str_replace($order, " ", $additionalInfo);

   // Get rid of multiple spaces
   $additionalInfo = preg_replace("/\s+/", " ", $additionalInfo);

   // Get specific div with additional information.
   $additionalInfoPattern = "/\<(div|ol|ul) class\=\"additionalInfo.*\<\/div\>/U";

   // Get the question text
   preg_match($additionalInfoPattern, $additionalInfo, $matches);

   // Now we have the additional information
   // Let's get the bullets if they exist...

   $additionalInfo = $matches[0];

   $getBullets = preg_split("/\<(\/)?ul.*\>/U",$additionalInfo);

   //print_r($getBullets);
   //die();

   if(count($getBullets) > 1)
   {
      foreach($getBullets as $bull)
      {
         if(strpos($bull, "<li>") !== false)
         {
            if(strpos($bull, "<a") !== false)
            {
               // Get the links from the bullets
               $linksPattern = "/\<a href\=\"(.*)\".*\>(.*)\<\/a\>/U";
               preg_match_all($linksPattern, $bull, $myLinks);

               $pdf->SetTextColor(0,0,255);

               for($a = 0, $len = count($myLinks[1]); $a < $len; $a++)
               {
                  // Add additional information.
                  $pdf->SetX(167);
                  $pdf->Cell(50,$lineHeight, "", 0, 0, "C", true);
                  $pdf->Cell(315,$lineHeight,
                              trim(html_entity_decode(strip_tags("* " . $myLinks[2][$a]))),
                              0, 1, "L", true, $myLinks[1][$a]);

                  //echo $myLinks[1][$a] . "-->". $myLinks[2][$a] ."\n";
               }

               $pdf->SetTextColor(0,0,0);

               $pdf->SetX(167);
               $pdf->Cell(365,10, "", 0, 1, "C", true);

               /*
               $bull = trim(html_entity_decode(strip_tags($bull)));
               if(!empty($bull))
               {
                  // Add additional information.
                  $pdf->SetX(167);
                  $pdf->MultiCell(365,$lineHeight, "Bullet: ".$bull, 0, "L", true);
                  $pdf->SetX(167);
                  $pdf->Cell(365,10, "", 0, 1, "C", true);
               }
               */
            }
            else
            {
               // Get the links from the bullets
               $liTag = "/\<\/li\>/U";
               $myBulls2 = preg_split($liTag, $bull);

               for($a = 0, $len = count($myBulls2); $a < $len; $a++)
               {
                  $myBulls2[$a] = trim($myBulls2[$a]);
                  if(!empty($myBulls2[$a]))
                  {

                     $orgY = $pdf->GetY();

                     // Add additional information.
                     $pdf->SetX(167);
                     $pdf->Cell(50,$lineHeight, "", 0, 0, "C", true);
                     $pdf->Cell(15,$lineHeight, "* ", 0, 0, "L", true);
                     $pdf->MultiCell(300,$lineHeight,
                                 trim(html_entity_decode(strip_tags($myBulls2[$a]))),
                                 0, "L", true);

                     if($pdf->GetY() > $orgY)
                     {
                        $pdf->SetX(167);
                        $tmpY = $pdf->GetY();
                        $pdf->SetY($orgY + $lineHeight);
                        $pdf->Cell(167,$tmpY - $orgY-$lineHeight, "", 0, 0, "C", true);
                        $pdf->SetY($tmpY);
                     }
                  }
               }

               $pdf->SetTextColor(0,0,0);

               $pdf->SetX(167);
               $pdf->Cell(365,10, "", 0, 1, "C", true);
            }
         }
         else
         {
            $bull = trim(html_entity_decode(strip_tags($bull)));
            if(!empty($bull))
            {
               // Add additional information.
               $pdf->SetX(167);
               $pdf->MultiCell(365,$lineHeight, $bull, 0, "L", true);
               $pdf->SetX(167);
               $pdf->Cell(365,10, "", 0, 1, "C", true);
            }
         }
      }
   }
   else
   {
      $additionalInfo = trim(html_entity_decode(strip_tags($additionalInfo)));

      if(!empty($additionalInfo))
      {
         // Add additional information.
         $pdf->SetX(167);
         $pdf->MultiCell(365,$lineHeight, $additionalInfo, 0, "L", true);
         $pdf->SetX(167);
         $pdf->Cell(365,10, "", 0, 1, "C", true);
      }
   }
}


// Add additional fill on the left if necessary.
if($stopY < $pdf->GetY()+$lineHeight)
{
   $currentY = $pdf->GetY();
   $pdf->SetX(67);
   $pdf->SetY($stopY);
   $pdf->Cell(100,($currentY-$stopY + $lineHeight), "", 0, 1, "C", true);
   $pdf->SetY($currentY);
}
else if($stopY > $pdf->GetY()+$lineHeight)
{
   $currentY = $pdf->GetY();
   $pdf->SetY($currentY);
   $pdf->SetX(167);
   $pdf->Cell(365,$stopY-$currentY-$lineHeight, "", 0, 1, "C", true);

   $pdf->SetY($stopY-$lineHeight);

/*
   $currentY = $pdf->GetY();
   $pdf->SetX(167);
   $pdf->SetY($stopY);
   $pdf->Cell(100,($currentY-$stopY + $lineHeight), "", 0, 1, "C", true);
   $pdf->SetY($currentY);
*/
}

$pdf->SetX(167);
$pdf->Cell(184,$lineHeight, "For the full text of the law, visit the ", 0, 0, "L", true);
$pdf->SetTextColor(0,0,255);
$pdf->Cell(181,$lineHeight, "U.S. Copyright Office website.", 0, 1, "L", true, "http://www.copyright.gov/title17/92chap1.html#110");
$pdf->Cell(465,$lineHeight/2, "", 0, 1, "C", true);

$pdf->SetTextColor(102,102,102);
$pdf->Ln(25);
$pdf->SetFontSize(8);
$lineHeight = 9;


$pdf->SetFont('', "BI");
$pdf->Write($lineHeight,"*Disclaimer:  ");
$pdf->SetFont('', "I");
$pdf->Write($lineHeight,"This document is intended to help educators better understand the educational exceptions available to them in U.S. Copyright Law. It is not a source of legal advice or assistance. The results are only as good as the input provided by the user and are intended to suggest next steps, and not to provide a final judgment.");

$pdf->SetFont('', "");

$notes = "";

// Figure out how to get all of the notes...



// Figure out what notes to include...
if(isset($_SESSION["includeNotes"]) && $_SESSION["includeNotes"])
{
   $pdf->AddPage();
   $pdf->SetTextColor(0,0,0);

   if(isset($_SESSION["legalCopy"]))
   {
      $pdf->ShowNotes(GetNotes($applicationPages["legalCopy"], $_SESSION["legalCopy"]));

      if($_SESSION["legalCopy"])
      {
         if(isset($_SESSION["faceToFace"]))
         {
            $pdf->ShowNotes(GetNotes($applicationPages["faceToFace"], $_SESSION["faceToFace"]));

            if(!$_SESSION["faceToFace"])
            {
               if(isset($_SESSION["onlineInstruction"]))
               {
                  $pdf->ShowNotes(GetNotes($applicationPages["onlineInstruction"], $_SESSION["onlineInstruction"]));

                  if($_SESSION["onlineInstruction"])
                  {
                     if(isset($_SESSION["allowedUsers"]))
                     {
                        $pdf->ShowNotes(GetNotes($applicationPages["allowedUsers"], $_SESSION["allowedUsers"]));

                        if($_SESSION["allowedUsers"])
                        {
                           if(isset($_SESSION["primarilyInstruction"]))
                           {
                              $pdf->ShowNotes(GetNotes($applicationPages["primarilyInstruction"], $_SESSION["primarilyInstruction"]));

                              if($_SESSION["primarilyInstruction"])
                              {
                                 if(isset($_SESSION["selectedByInstructor"]))
                                 {
                                    $pdf->ShowNotes(GetNotes($applicationPages["selectedByInstructor"], $_SESSION["selectedByInstructor"]));

                                    if($_SESSION["selectedByInstructor"])
                                    {
                                       if(isset($_SESSION["learningGoals"]))
                                       {

                                          $pdf->ShowNotes(GetNotes($applicationPages["learningGoals"], $_SESSION["learningGoals"]));

                                          if($_SESSION["learningGoals"])
                                          {
                                             if(isset($_SESSION["comparableAmount"]))
                                             {
                                                $pdf->ShowNotes(GetNotes($applicationPages["comparableAmount"], $_SESSION["comparableAmount"]));

                                                if($_SESSION["comparableAmount"])
                                                {
                                                   if(isset($_SESSION["reasonableAndLimited"]))
                                                   {
                                                      $pdf->ShowNotes(GetNotes($applicationPages["reasonableAndLimited"], $_SESSION["reasonableAndLimited"]));

                                                      if($_SESSION["reasonableAndLimited"])
                                                      {
                                                         if(isset($_SESSION["digitalVideo"]))
                                                         {
                                                            $pdf->ShowNotes(GetNotes($applicationPages["digitalVideo"], $_SESSION["digitalVideo"]));

                                                            if($_SESSION["digitalVideo"])
                                                            {
                                                               if(isset($_SESSION["institutionalMeasures"]))
                                                               {
                                                                  $pdf->ShowNotes(GetNotes($applicationPages["institutionalMeasures"], $_SESSION["institutionalMeasures"]));
                                                               }
                                                            }
                                                         }
                                                      }
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   }
}

$pdf->Output("Educational_Exemption.pdf", "D");
//$pdf->Output();

// This function checks to see if there's enough room on the page
// for the section about to be written.
function availableSpace($pdf, $lineHeight, $content)
{

   // Need to check if we can fit the section on the page.
   $lines = explode("<br>", nl2br($content));
   $linesNeeded = count($lines);

   // Account for padding.
   $linesNeeded+= 2;

   foreach($lines as $line)
   {
      if(!empty($line))
      {
         if(strlen($line) > 110)
            $linesNeeded++;
      }
   }

   if( ($linesNeeded*$lineHeight) > ($pdf->CurPageFormat[1] - ($pdf->bMargin + $pdf->tMargin + $pdf->GetY())))
      return false;
   else
      return true;
}

function GetNotes($filename, $answer)
{
   global $popUpNotes;

   $file_contents = file_get_contents("../".$filename);

   // Get rid of PHP tags
   // $file_contents = preg_replace("/\<\?php(.*?)\?\>/s", "", $file_contents);
   $order   = array("\r\n", "\n", "\r");
   $file_contents = str_replace($order, " ", $file_contents);

   $file_contents = preg_replace("/\s+/", " ", $file_contents);

   $questionPattern = "/\<(div|ol|ul|p) class\=\"questionText\".*\<\/div\>/";
   $answerPattern = "/\<div class\=\"answerOptions\".*\<\/div\>/";

   // Important that note links must be coded in this order!
   $notesPattern = "/\<a href\=\"shownote\.php\?n=([a-zA-Z0-9]*)\" class=\"toolTip smallLink\"\>([^>]*)\<\/a\>/";

   // Get the question text
   preg_match($questionPattern, $file_contents, $matches);
   $file_contents = $matches[0];

   // Get rid of the answer text
   $file_contents = preg_replace($answerPattern, "", $file_contents);

   preg_match_all($notesPattern, $file_contents, $notes);
   $file_contents = preg_replace($answerPattern, "", $file_contents);
   $notes = $notes[1];

   // Get rid of footnote links
   $file_contents = preg_replace($notesPattern, "||||REPLACE_WITH_FOOTNOTE||||", $file_contents);
   $thisFootnotes = array();

   // Get footnote text
   foreach($notes as $note)
   {
      $tmp = html_entity_decode(strip_tags(str_replace(array("<br />","<br>"), "\n",$popUpNotes[$note])));
      $thisFootnotes[] = str_replace("\n ", "\n", $tmp);
   }

   // Package it all together and send it off!
   $thisNote = array();
   $thisNote["mainNotes"] = trim(html_entity_decode(strip_tags($file_contents)));
   $thisNote["answer"] = $answer;
   $thisNote["footNotes"] = $thisFootnotes;

   return $thisNote;
}


?>