<?php
/************************************************************************
 * FILE:   browserCheck.php                                             *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file is used to check the browser being used and assigns a      *
 * variable based on the browser. This file also sets a boolean         *
 * variable for whether Internet Explorer is used.                      *
 *                                                                      *
 * CLASSES USED:                                                        *
 *    - None                                                            *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - "includes/properties.php"                                       *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - None                                                            *
 *                                                                      *
 * JAVASCRIPT:                                                          *
 *    - None                                                            *
 *                                                                      *
 * STYLE SHEETS:                                                        *
 *    - None                                                            *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - None                                                            *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

if (!empty($_SERVER['HTTP_USER_AGENT']))
{
   $HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
}
else if (!empty($HTTP_SERVER_VARS['HTTP_USER_AGENT']))
{
   $HTTP_USER_AGENT = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
}
else if (!isset($HTTP_USER_AGENT))
{
   $HTTP_USER_AGENT = '';
}
if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[2];
   $browser = 'opera';
}
else if (ereg('MSIE ([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[1];
   $browser = 'ie';
}
else if (ereg('OmniWeb/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[1];
   $browser = 'omniweb';
}
else if (ereg('Netscape([0-9]{1})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[1];
   $browser = 'netscape';
}
else if (ereg('Mozilla/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[1];
   $browser = 'mozilla';
}
else if (ereg('Konqueror/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
{
   $browserVersion = $log_version[1];
   $browser = 'konqueror';
}
else
{
   $browserVersion = 0;
   $browser = 'other';
}

if($browser == 'ie')
   $ie = true;
else
   $ie = false;

?>