/************************************************************************
 * FILE:   popUp.js                                                     *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file contains the JavaScript that emulates a "pop-up window"    *
 * using CSS and JavaScript. The fading/opacity portion of this script  *
 * was taken from                                                       *
 *    http://www.brainerror.net/scripts/javascript/blendtrans/          *
 * Modifications to this code were all made by 100 Pianos Web           *
 * Development and Design.                                              *
 *                                                                      *
 * GLOBAL VARIABLES:                                                    *
 *    - popUpContent         - Used to store the content that will      *
 *                             populate the "pop-up window".            *
 *                                                                      *
 *    - maskOpacity          - Opacity value for the mask used to hide  *
 *                             the "parent" window.                     *
 *                                                                      *
 *    - popUpDelay           - Milliseconds that the "pop-up window"    *
 *                             should take to fully display.            *
 *                                                                      *
 *    - maskBGColor          - Background color of the masking div.     *
 *                                                                      *
 *    - startPopUpWidth      - Scale by which the "pop-up window"       *
 *                             width should grow.                       *
 *                                                                      *
 *    - startPopUpHeight     - Scale by which the "pop-up window"       *
 *                             width should grow.                       *
 *                                                                      *
 *    - stopPopUpWidth       - Scale by which the "pop-up window"       *
 *                             width should shrink.                     *
 *                                                                      *
 *    - stopPopUpHeight      - Scale by which the "pop-up window"       *
 *                             width should shrink.                     *
 *                                                                      *
 *    - growthDelay          - Amount of time between "pop-up window"   *
 *                             growth spurts.                           *
 *                                                                      *
 *    - popUpURL             - URL of the page to be called via AJAX.   *
 *                             This is where the content for the        *
 *                             "pop-up window" comes from.              *
 *                                                                      *
 *    - viewableScreenWidth  - Width of the browser window. Used in     *
 *                             styling the masking div.                 *
 *                                                                      *
 *    - viewableScreenHeight - Height of the browser window. Used in    *
 *                             styling the masking div.                 *
 *                                                                      *
 *    - myMask               - Variable used to store the masking div.  *
 *                                                                      *
 *    - popWindow            - Variable used to store the "pop-up       *
 *                             window" div.                             *
 *                                                                      *
 *    - lastYVal             - Variable used to keep the screen from    *
 *                             scrolling when the "pop-up window" is    *
 *                             displayed.                               *
 *                                                                      *
 *    - closeBtnContent      - Variable used to store the HTML used for *
 *                             the "close" button on the                *
 *                             "pop-up window".                         *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - initPopUpElements    - Initializes the variables needed for the *
 *                             "pop-up window".                         *
 *                                                                      *
 *    - empty                - Checks to see if a variable has been     *
 *                             initialized or not.                      *
 *                                                                      *
 *    - setWindowDimensions  - Calculates viewable window dimensions    *
 *                             and stores them in the global variables  *
 *                             viewableScreenWidth and                  *
 *                             viewableScreenHeight.                    *
 *                                                                      *
 *    - setMaskAttributes    - Sets masking div attributes.             *
 *                                                                      *
 *    - setPopupAttributes   - Sets "pop-up window" div attributes.     *
 *                                                                      *
 *    - getCurrentTop        - Gets the current scrolled window         *
 *                             position.                                *
 *                                                                      *
 *    - showPopUp            - Displays "pop-up window".                *
 *                                                                      *
 *    - hidePopUp            - Hides "pop-up window".                   *
 *                                                                      *
 *    - resetPageDimensions  - Adjusts page dimensions when the browser *
 *                             window is resized.                       *
 *                                                                      *
 *    - opacity              - Used to fade in the masking div.         *
 *                                                                      *
 *    - changeOpac           - Helper function for opacity function.    *
 *                                                                      *
 *    - startPopUp           - Used to initialize the "pop-up window".  *
 *                                                                      *
 *    - loadContent          - Called when the AJAX request has         *
 *                             completed the HTTP request.              *
 *                                                                      *
 *    - getFileName          - Parses a file name from a URL.           *
 *                                                                      *
 *    - growPopUpWidth       - Increases the width of the "pop-up       *
 *                             window".                                 *
 *                                                                      *
 *    - growPopUpHeight      - Increases the height of the "pop-up      *
 *                             window".                                 *
 *                                                                      *
 *    - ungrowPopUp          - Resets the dimensions of the "pop-up     *
 *                             window".                                 *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - In order to use this script, be sure to add the following       *
 *      attributes to your <body> tag:                                  *
 *           onload="initPopUpElements()"                               *
 *           onresize="resetPageDimensions()"                           *
 *                                                                      *
 *    - It is recommended that you not edit anything in this script     *
 *      other than the following variables:                             *
 *           - maskOpacity                                              *
 *           - popUpDelay                                               *
 *           - maskBGColor                                              *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/


 
/*********************************************************************
 * Below are the variables you can edit for this script. If you'd    *
 * like to modify the script more, feel free but do so at your own   *
 * risk.                                                             *
 *********************************************************************/
var maskOpacity          = 80;                  // in percent. 90 = 90% visible. Default is 80.
var popUpDelay           = 250;                 // In milliseconds. Default is 500.
var maskBGColor          = "#000000";           // Default is gray




/*******************************************************************
 *      IT IS RECOMMENDED THAT YOU NOT EDIT BELOW THIS LINE!!!     *
 *******************************************************************/
var popUpContent = "";
var startPopUpWidth      = 3;
var startPopUpHeight     = 3;
var stopPopUpWidth       = 2;
var stopPopUpHeight      = 2;
var growthDelay = 5;
var popUpURL = "popUp.php";
var viewableScreenWidth;
var viewableScreenHeight;
var myMask;
var popWindow;
var lastYVal;
var closeBtnContent = "<div class=\"popUpCloseBtn\"><a href=\"#\" onclick=\"hidePopUp(); return false\">X</a></div>";

/*********************************************************
 * FUNCTION: initPopUpElements                           *
 *                                                       *
 * PURPOSE: Initializes the variables needed for the     *
 *          "pop-up window".                             *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function initPopUpElements()
{
   // Set defaults for required variables.
   if(empty(maskOpacity))
      maskOpacity = 90;
   if(empty(popUpDelay))
      popUpDelay = 500;
   if(empty(maskBGColor))
      maskBGColor = "#333";

   lastYVal = 0;

   // Create the mask
   myMask = document.createElement( "div" );
   setWindowDimensions();

   // Set permanent mask attributes
   myMask.id = "myMask";
   myMask.style.backgroundColor = maskBGColor;
   myMask.style.position = "absolute";
   myMask.style.display = "none";
   opacity("myMask", 100, 0, 1)

   // Set permanent pop-up attributes
   popWindow = document.createElement( "div" );
   popWindow.id = "popUpWindow";
   popWindow.style.position = "absolute";
   popWindow.style.display = "none";
   popWindow.style.overflow = "auto";

   // Add onResize event listener.
   window.onresize = function() { resetPageDimensions() };

   // Set dynamic attributes
   // for new elements
   setMaskAttributes();

   // Add content to the pop-up window.
   popWindow.innerHTML = closeBtnContent + "<div class=\"loadingPopup\" >loading</div>";

   // Add elements to the DOM
   document.body.appendChild(myMask);
   document.body.appendChild(popWindow);
   
   // Time to find the pop-up links!
   var myLinks = document.body.getElementsByTagName("a");
   for(var a = 0; a < myLinks.length; a++)
   {
      if(myLinks[a].className.indexOf("popUp") != -1)
      {
         var gotoPage = myLinks[a].href;
         myLinks[a].href = "javascript: startPopUp('" + gotoPage + "');";
      }
   }
}

/*********************************************************
 * FUNCTION: empty                                       *
 *                                                       *
 * PURPOSE: Checks to see if a variable has been         *
 *          initialized or not.                          *
 *                                                       *
 * PARAMETERS: variable - The variable to be checked.    *
 *                                                       *
 * RETURNS: Boolean true or false.                       *
 *                                                       *
 *********************************************************/
function empty(variable)
{
   if(variable == "" || variable == undefined)
      return true;
   return false;
}

/*********************************************************
 * FUNCTION: setWindowDimensions                         *
 *                                                       *
 * PURPOSE: Calculates viewable window dimensions and    *
 *          stores them in the global variables,         *
 *          "viewableScreenWidth" and                    *
 *          "viewableScreenHeight".                      *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: Boolean true or error.                       *
 *                                                       *
 *********************************************************/
function setWindowDimensions()
{
   if (document.documentElement)
   {
      var dombody = document.body;
      if ((document.body.clientHeight == document.body.offsetHeight) &&
          (document.body.offsetHeight == document.body.scrollHeight))
      {
         dombody = document.documentElement;
      }
      if ((document.body.clientHeight == 0) &&
          (document.documentElement.clientHeight > 0))
      {
         dombody = document.documentElement;
      }

      viewableScreenWidth = dombody.clientWidth;
      viewableScreenHeight = dombody.clientHeight;

      // Non-IE browsers can simply use window.innerHeight
      if((window.navigator.userAgent.indexOf("MSIE") == -1))
         viewableScreenHeight = window.innerHeight;
   }
   else
   {
      viewableScreenWidth = window.screen.width;
      viewableScreenHeight = window.screen.height;
   }
   
   return true;
}

/*********************************************************
 * FUNCTION: setMaskAttributes                           *
 *                                                       *
 * PURPOSE: Sets masking div attributes.                 *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function setMaskAttributes()
{
   myMask.style.height =  viewableScreenHeight + "px";
   myMask.style.width = viewableScreenWidth+30 + "px";

   myMask.style.top = getCurrentTop() + "px";

   myMask.style.left = "0px";

   setPopupAttributes();
}

/*********************************************************
 * FUNCTION: setPopupAttributes                          *
 *                                                       *
 * PURPOSE: Sets "pop-up window" div attributes.         *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function setPopupAttributes()
{
   popWindow.style.width = (parseInt(viewableScreenWidth/startPopUpWidth)) + "px";
   popWindow.style.height = (parseInt(viewableScreenHeight/startPopUpHeight)) + "px";

   popWindow.style.top = (parseInt(getCurrentTop() +
                         (viewableScreenHeight/4))) + "px";

   popWindow.style.left = (parseInt(viewableScreenWidth/3)) + "px";
}

/*********************************************************
 * FUNCTION: getCurrentTop                               *
 *                                                       *
 * PURPOSE: Gets the current scrolled window position.   *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: The Y value of current viewable page.        *
 *                                                       *
 *********************************************************/
function getCurrentTop()
{
   var currentTop = 0;
   if( typeof( window.pageYOffset ) == 'number' )
      currentTop = window.pageYOffset;
   else if( document.body && ( document.body.scrollLeft ||
                               document.body.scrollTop ) )
      currentTop = document.body.scrollTop;
   else if( document.documentElement &&
            ( document.documentElement.scrollLeft ||
              document.documentElement.scrollTop
            )
          )
      currentTop = document.documentElement.scrollTop;
   return currentTop;
}

/*********************************************************
 * FUNCTION: showPopUp                                   *
 *                                                       *
 * PURPOSE: Displays "pop-up window".                    *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function showPopUp()
{
   lastYVal = getCurrentTop();
   setMaskAttributes()
   opacity("myMask", 0, maskOpacity, popUpDelay);
   document.body.style.overflow = "hidden";
   window.scrollTo(0,lastYVal);
   myMask.style.top = getCurrentTop() + "px";

   myMask.style.display = "block";
   popWindow.style.display = "block";
   window.scrollTo(0,lastYVal);
   
   growPopUpWidth((parseInt(popWindow.style.width)), (parseInt(viewableScreenWidth/stopPopUpWidth)));
   
   return;
}

/*********************************************************
 * FUNCTION: hidePopUp                                   *
 *                                                       *
 * PURPOSE: Hides "pop-up window".                       *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function hidePopUp()
{
   popWindow.style.display = "none";
   opacity("myMask", maskOpacity, 0, popUpDelay);
   myMask.style.display = "none";

   document.body.style.overflow = "auto";
   window.scrollTo(0,lastYVal);

   popWindow.innerHTML = "<div class=\"loadingPopup\" ></div>";
   ungrowPopUp();
   return;
}

/*********************************************************
 * FUNCTION: resetPageDimensions                         *
 *                                                       *
 * PURPOSE: Adjusts page dimensions when the browser     *
 *          window is resized.                           *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function resetPageDimensions()
{
   if(setWindowDimensions())
      setMaskAttributes();
}

/*********************************************************
 * FUNCTION: opacity                                     *
 *                                                       *
 * PURPOSE: Used to fade in the masking div.             *
 *                                                       *
 * PARAMETERS:  - id        - The id attribute of the    *
 *                            element being faded.       *
 *                                                       *
 *              - opacStart - The starting opacity       *
 *                                                       *
 *              - opacEnd   - The ending opacity         *
 *                                                       *
 *              - millisec  - The amount of milliseconds *
 *                            that the fade should take  *
 *                            place over                 *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function opacity(id, opacStart, opacEnd, millisec)
{
   //speed for each frame
   var speed = Math.round(millisec / 100);
   var timer = 0;

   //determine the direction for the blending, if start and end are the same nothing happens
   if(opacStart > opacEnd)
   {
      for(i = opacStart; i >= opacEnd; i--)
      {
         setTimeout("changeOpac(" + i + ",'" + id + "')",(timer * speed));
         timer++;
      }
   }
   else if(opacStart < opacEnd)
   {
      for(i = opacStart; i <= opacEnd; i++)
      {
         setTimeout("changeOpac(" + i + ",'" + id + "')",(timer * speed));
         timer++;
      }
   }
}
 
/*********************************************************
 * FUNCTION: changeOpac                                  *
 *                                                       *
 * PURPOSE: Helper function for opacity function. Simply *
 *          changes the opacity value of an element.     *
 *                                                       *
 * PARAMETERS:  - opacity   - The new opacity value for  *
 *                            the element.               *
 *                                                       *
 *              - id        - The id attribute of the    *
 *                            element being faded.       *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function changeOpac(opacity, id)
{
   var object = document.getElementById(id).style;
   object.opacity = (opacity / 100);
   object.MozOpacity = (opacity / 100);
   object.KhtmlOpacity = (opacity / 100);
   object.filter = "alpha(opacity=" + opacity + ")";
}

/*********************************************************
 * FUNCTION: startPopUp                                  *
 *                                                       *
 * PURPOSE: Used to initialize the "pop-up window".      *
 *                                                       *
 * PARAMETERS:  - contentLocation - The URL where the    *
 *                                  content for the      *
 *                                  "pop-up window"      *
 *                                  exists.              *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function startPopUp(contentLocation)
{
   // We temporarily hide any overflow
   // while opening the pop-up window.
   popWindow.style.overflow = "hidden";
   
   // Make sure the content is shown as loading.
   popWindow.innerHTML = closeBtnContent + "<div class=\"loadingPopup\" >loading</div>";

   // Create AJAX object
   var myAjax = new Ajax(popUpURL, loadContent);
   myAjax.returnType = "full";

   // Send AJAX call.
   myAjax.send("content="+encodeURI(getFileName(contentLocation)), "GET");

   // While we wait for the return from the AJAX object,
   // we'll go ahead and open the pop-up window.
   showPopUp();
}
 
/*********************************************************
 * FUNCTION: loadContent                                 *
 *                                                       *
 * PURPOSE: Used to initialize the "pop-up window".      *
 *                                                       *
 * PARAMETERS:  - response - The return value from the   *
 *                           HTTP request via the AJAX   *
 *                           object.                     *
 *                                                       *
 *              - status   - The HTTP status code        *
 *                           returned by the HTTP        *
 *                           request via the AJAX object *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function loadContent(response, status)
{
   // If we have a valid return, then we
   // populate the pop-up window.
   if(status == 200)
   {
      popUpContent = response;
 
      // Load content
      popWindow.innerHTML = closeBtnContent +
                            popUpContent;
   }
   // If we got an invalid return, then
   // we tell the user that there was an error.
   else
      popWindow.innerHTML = closeBtnContent +
                               "<h2>ERROR</h2><p><em>Unable to retrieve content.</em></p>";
}

/*********************************************************
 * FUNCTION: getFileName                                 *
 *                                                       *
 * PURPOSE: Parses a file name from a URL.               *
 *                                                       *
 * PARAMETERS:  - fullURL - The full URL to be parsed    *
 *                                                       *
 * RETURNS: String representation of the file name       *
 *                                                       *
 *********************************************************/
function getFileName(fullURL)
{
   // Get rid of the query string.
   var parts = fullURL.split('\?');
   
   // Get rid of host/directory info.
   parts = parts[0].split('/');

   // Return the file name.
   return parts[(parts.length-1)];
}

/*********************************************************
 * FUNCTION: growPopUpWidth                              *
 *                                                       *
 * PURPOSE: Increases the width of the "pop-up window".  *
 *                                                       *
 * PARAMETERS:  - currentWidth - The current width of    *
 *                               the "pop-up window"     *
 *                                                       *
 *              - stopWidth    - The final desired width *
 *                               of the "pop-up window"  *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function growPopUpWidth(currentWidth, stopWidth)
{
   // Figure out what the current left position is.
   currentPopUpPosition = (parseInt(popWindow.style.left));
   // Adjust the width.
   currentWidth = currentWidth + 20;
   // Adjust the left position.
   currentPopUpPosition-=10;

   // Apply the new values to the style attributes.
   popWindow.style.width = currentWidth + "px";// + "px";
   popWindow.style.left  = currentPopUpPosition + "px";

   // If we're not done growing wider, then
   // we call the function again.
   if(currentWidth < stopWidth)
   {
      timeoutString = "growPopUpWidth("+currentWidth+","+stopWidth+")";
      setTimeout(timeoutString, growthDelay);
   }
   // Otherwise, we start to grow taller.
   else
   {
      setTimeout("growPopUpHeight("
                  +(parseInt(popWindow.style.height))
                  +","
                  +(parseInt(viewableScreenHeight/stopPopUpHeight))
                  +")", growthDelay);
   }
}

/*********************************************************
 * FUNCTION: growPopUpHeight                             *
 *                                                       *
 * PURPOSE: Increases the height of the "pop-up window". *
 *                                                       *
 * PARAMETERS:  - currentHeight - The current height of  *
 *                                the "pop-up window"    *
 *                                                       *
 *              - stopHeight    - The final desired      *
 *                                height of the "pop-up  *
 *                                window"                *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function growPopUpHeight(currentHeight, stopHeight)
{
   // Figure out what the current top position is.
   currentPopUpPosition = (parseInt(popWindow.style.top));
   // Adjust the height.
   currentHeight = currentHeight + 20;
   // Adjust the top position.
   currentPopUpPosition-=10;

   // Apply the new values to the style attributes.
   popWindow.style.height = currentHeight+ "px";// + "px";
   popWindow.style.top  = currentPopUpPosition + "px";

   // If we're not done growing taller, then
   // we call the function again.
   if(currentHeight < stopHeight)
   {
      timeoutString = "growPopUpHeight("+currentHeight+","+stopHeight+")";
      setTimeout(timeoutString, growthDelay);
   }
   // When we're all done growing, we turn
   // overflow back on.
   else
   {
      popWindow.style.overflow = "auto";
   }
}

/*********************************************************
 * FUNCTION: ungrowPopUp                                 *
 *                                                       *
 * PURPOSE: Resets the dimensions of the "pop-up window" *
 *                                                       *
 * PARAMETERS: None                                      *
 *                                                       *
 * RETURNS: None                                         *
 *                                                       *
 *********************************************************/
function ungrowPopUp()
{
   popWindow.style.width = (parseInt(viewableScreenWidth/startPopUpWidth)) + "px";
   popWindow.style.height = (parseInt(viewableScreenHeight/startPopUpHeight)) + "px";
}