/************************************************************************
 * FILE:   standard.js                                                  *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file contains miscellaneous JavaScript functions needed         *
 * throughout the application.                                          *
 *                                                                      *
 * GLOBAL VARIABLES:                                                    *
 *    - ie           - Used to store whether the user is viewing the    *
 *                     application using Internet Explorer.             *
 *                                                                      *
 *    - radioButtons - Non-native JavaScript object used to store all   *
 *                     of the radio button elements on a given page.    *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *    - initCheckboxRadioButtons - This function initializes the radio  *
 *                                 buttons so that they look like       *
 *                                 checkboxes. It also assigns the      *
 *                                 onclick value for each of the radio  *
 *                                 buttons.                             *
 *                                                                      *
 *    - setBackButton            - Used to convert the back button into *
 *                                 a form button to allow the forms to  *
 *                                 go backwards.                        *
 *                                                                      *
 *    - newWindowLink            - Used to force links to open in a new *
 *                                 window while keeping the page XHTML  *
 *                                 1.0 valid.                           *
 *                                                                      *
 *    - updateSessionVars        - Used for the final page of the tool. *
 *                                 Used to make sure that the           *
 *                                 information entered into the form on *
 *                                 the last page is included in the PDF *
 *                                 if one is created.                   *
 *                                                                      *
 *    - endSessionUpdate         - Null function used to end the        *
 *                                 AJAX call.                           *
 *                                                                      *
 *    - updateTextarea           - Used for adding bullets from the     *
 *                                 "pop-up window" to the text area on  *
 *                                 the parent page.                     *
 *                                                                      *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - None                                                            *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/


// Determine what browser is being used
ie = (window.navigator.appName.indexOf("Internet Explorer") != -1);

// Create object for storing radio buttons
var radioButtons = new Object();
radioButtons.length = 0;

/****************************************************
 * FUNCTION: initCheckboxRadioButtons               *
 *                                                  *
 * PURPOSE:  This function initializes the radio    *
 *           buttons so that they look like         *
 *           checkboxes. It also assigns the        *
 *           onclick value for each of the radio    *
 *           buttons.                               *
 *                                                  *
 * PARAMETERS:  None.                               *
 *                                                  *
 * RETURNS:     None.                               *
 ****************************************************/
function initCheckboxRadioButtons()
{
   // Get all input elements
   var inputs = document.getElementsByTagName("input");

   // Loop through input elements and find all
   // radio buttons
   for(var a = 0; a < inputs.length; a++)
   {
      if(inputs[a].type == "radio")
      {
         var radioName = inputs[a].name;

         // For each set of radio buttons,
         // we create a new array.
         if(radioButtons[radioName] == null)
         {
            radioButtons[radioName] = new Array();
            radioButtons[radioName].push(inputs[a]);
            radioButtons.length++;
         }
         else
         {
            radioButtons[radioName].push(inputs[a]);
         }

         // Hide radio buttons by making them
         // completely opaque.
         var opacity = 0;
         inputs[a].style.opacity = (opacity / 100);
         inputs[a].style.MozOpacity = (opacity / 100);
         inputs[a].style.KhtmlOpacity = (opacity / 100);
         inputs[a].style.filter = "alpha(opacity=" + opacity + ")";
         if(inputs[a].checked)
            inputs[a].parentNode.style.backgroundPosition = "0px 0px";

         // Add onclick funtionality for
         // the radio button that will update the
         // background image to indicate that the
         // radio button has been checked.
         inputs[a].onclick= function()
         {
            for(var b = 0; b < radioButtons[this.name].length; b++)
            {
               if(radioButtons[this.name][b].checked)
               {
                  radioButtons[this.name][b].parentNode.style.backgroundPosition = "0 0";
               }
               else
               {
                  radioButtons[this.name][b].parentNode.style.backgroundPosition = "-21px -21px";
               }
            }
         }
      }
   }
}

/****************************************************
 * FUNCTION: setBackButton                          *
 *                                                  *
 * PURPOSE:  Used to convert the back button into a *
 *           form button to allow the forms to go   *
 *           backwards.                             *
 *                                                  *
 * PARAMETERS:  None.                               *
 *                                                  *
 * RETURNS:     None.                               *
 ****************************************************/
function setBackButton()
{
   // Get the "Back" button
   var backBtn = document.getElementById("backLinkTop");

   // Make sure we don't show links we aren't supposed to.
   if(backBtn.className.indexOf("noLink") != -1)
      return;

   // Create the form element to replace the
   // "Back" button.
   var x = document.createElement('input');
   x.type="button";
   x.name="backLinkTop";
   x.value="Back";
   x.id="backLinkTop"

   // Add onclick functionality to the
   // form button to ensure that the form
   // information is submitted properly.
   x.onclick = function()
   {
      document.getElementById("fairUseForm").action = document.getElementById("prevPage").value;
      document.getElementById("fairUseForm").submit();
   }

   // Replace the "Back" button with the form
   // element created above.
   backBtn.parentNode.replaceChild(x,backBtn);
}

/****************************************************
 * FUNCTION: newWindowLink                          *
 *                                                  *
 * PURPOSE:  Used to force links to open in a new   *
 *           window while keeping the page XHTML    *
 *           1.0 valid.                             *
 *                                                  *
 * PARAMETERS:  link - Link element.                *
 *                                                  *
 * RETURNS:     None.                               *
 ****************************************************/
function newWindowLink(link)
{
   // We use a date value to ensure that windows
   // arent't overwriten by one another.
   var d = new Date();
   window.open(link.href,"newWindows"+d.getTime());
}


/****************************************************
 * FUNCTION: updateSessionVars                      *
 *                                                  *
 * PURPOSE:  Used for the final page of the tool.   *
 *           Used to make sure that the information *
 *           entered into the form on the last page *
 *           is included in the PDF if one is       *
 *           created.                               *
 *                                                  *
 * PARAMETERS:  formElement - Form element whose    *
 *                            value needs to be     *
 *                            added to the session. *
 *                                                  *
 * RETURNS:     None.                               *
 ****************************************************/
function updateSessionVars(formElement)
{
   // Create AJAX object
   var myAjax = new Ajax("setSessionVar.php", endSessionUpdate);
   myAjax.returnType = "full";

   // Send AJAX call.
   myAjax.send(formElement.name+"="+encodeURI(formElement.value), "GET");
}

/****************************************************
 * FUNCTION: endSessionUpdate                       *
 *                                                  *
 * PURPOSE:  Null function used to end the AJAX     *
 *           call.                                  *
 *                                                  *
 * PARAMETERS:  response - standard AJAX response   *
 *                         parameter.               *
 *                                                  *
 *              status   - standard AJAX response   *
 *                         parameter.               *
 *                                                  *
 * RETURNS:     None.                               *
 ****************************************************/
function endSessionUpdate(response, status)
{
   return;
}

/****************************************************
 * FUNCTION: updateTextarea                         *
 *                                                  *
 * PURPOSE:  Used for adding bullets from the       *
 *           "pop-up window" to the text area on    *
 *           the parent page..                      *
 *                                                  *
 * PARAMETERS:  txt   - Text to be appended to the  *
 *                      value of the textarea.      *
 *                                                  *
 *              alink - Link to hide (typically the *
 *                      parent link for the         *
 *                      function call.              *
 *                                                  *
 * RETURNS:     Returns false on success.           *
 ****************************************************/
function updateTextarea(txt, alink)
{
   // Find the textareas on the page.
   var ta = document.body.getElementsByTagName("textarea");

   // If there are textareas, we select the first one and
   // append the value passed to the function to the
   // value of the textarea.
   if(ta.length > 0)
   {
      ta = ta[0];
      ta.value = ta.value+txt+"\n";
   }
   
   // Hide the link that the function call
   // came from.
   alink.style.visibility = "hidden";
   
   // Return false to negate the mouse click on the link
   return false;
}
