<?php
/************************************************************************
 * FILE:   pdf/index.php                                                *
 * AUTHOR: Justin Spargur                                               *
 * DATE:   04/21/09                                                     *
 *                                                                      *
 * DESCRIPTION:                                                         *
 * This file is used to maintain a consistent header on the top of      *
 * every page in the application. This file is also used to determine   *
 * the progress as displayed on the progress bar and to create the      *
 * "Back" and "Next" links.                                             *
 *                                                                      *
 * CLASSES USED:                                                        *
 *    - None                                                            *
 *                                                                      *
 * INCLUDED FILES:                                                      *
 *    - "includes/sessionHandler.php"                                   *
 *    - "pdf/class.pdf.php"                                             *
 *                                                                      *
 * FUNCTIONS/METHODS INCLUDED:                                          *
 *     - availableSpace - Checks to see if there is enough room on the  *
 *                        page for the section about to be written.     *
 *                                                                      *
 * JAVASCRIPT:                                                          *
 *    - None                                                            *
 *                                                                      *
 * STYLE SHEETS:                                                        *
 *    - None                                                            *
 *                                                                      *
 * KNOWN BUGS:                                                          *
 *    - None                                                            *
 *                                                                      *
 * ADDITIONAL NOTES:                                                    *
 *    - None                                                            *
 *                                                                      *
 * CHANGES MADE:                                                        *
 *    - None                                                            *
 *                                                                      *
 ************************************************************************/

require_once("../includes/sessionHandler.php");
require_once("class.pdf.php");

// Set page format.
$pageFormat["pageOrientation"]   = "P";          // P, L
$pageFormat["unitOfMeasurement"] = "in";         // mm (default), pt, cm, in
$pageFormat["pageFormat"]        = "Letter";     // Letter, Legal, A4

// Set font format.
$defaultFont["family"] = "Arial";
$defaultFont["style"] = "";
$defaultFont["size"] = 12;

/************************************
 * DO NOT DELETE BELOW THIS LINE!!! *
 ************************************/

//Instanciation of PDF class
$pdf=new PDF("P","pt","Letter");

// Set title for the PDF
$pdf->SetTitle("Fair Use Evaluation Documentation");

// Set the margin for the header
$headerMargin = $pdf->lMargin;

// Set the default margin and page width
// Note: 50pt = .75in
$pdf->defaultMargin = 67;
$pdf->pageWidth = 567;

// Create a new page in the PDF
$pdf->AddPage();

// Set font face, size, color, and page margins
$pdf->SetFont('Helvetica');
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->SetFillColor(0,0,153);
$pdf->SetDrawColor(0,0,153);
$pdf->SetFontSize(28);

// Set the line height to match the font size
$lineHeight = 28;

// Create the first page heading
$pdf->Cell($page->pageWidth,$lineHeight,"Fair Use Evaluation Documentation",0,1,"C");
$pdf->SetFontSize(9);
$lineHeight = 11;
$pdf->Ln();

// Insert source information
$pdf->Write($lineHeight, "Compiled using the ");
$pdf->SetFont('', "B");
$pdf->Write($lineHeight, "Fair Use Evaluator");
$pdf->SetFont('', "");
$pdf->Write($lineHeight, " [cc] 2008 Michael Brewer & the Office for Information Technology Policy,");
$pdf->Ln();
$pdf->SetTextColor(0,0,255);
$pdf->SetFont('', "U");
$pdf->Write($lineHeight,"http://librarycopyright.net/fairuse/","http://librarycopyright.net/fairuse/");
$pdf->SetFont('', "");
$pdf->SetTextColor(0,0,0);

// Insert a horizontal rule
$pdf->DrawHR();

// Set font size and color
$lineHeight = 18;
$col2Start = 200;
$pdf->SetFillColor(247,223,255);
$pdf->SetDrawColor(247,223,255);


/*****************************
 *      USER INFORMATION     *
 *************************************************************************/
$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Name:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
// Need to adjust the margin in case of line breaks
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["userName"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Job Title:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["userJobTitle"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Institution:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["userInstitution"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Section  504(c)(i,ii):");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

if(isset($_SESSION["applies504"]))
{
   if($_SESSION["applies504"] == "y")
   {
      $pdf->Write($lineHeight,"Applies to this use ");
      $pdf->SetTextColor(0,0,255);
      $pdf->SetFont('', "U");
      $pdf->Write($lineHeight,"[link to the law]","http://intranet.library.arizona.edu/users/brewerm/");
      $pdf->SetFont('', "");
      $pdf->SetTextColor(0,0,0);
   }
   else if($_SESSION["applies504"] == "n")
   {
      $pdf->Write($lineHeight,"Does not appply to this use ");
      $pdf->SetTextColor(0,0,255);
      $pdf->SetFont('', "U");
      $pdf->Write($lineHeight,"[link to the law]","http://intranet.library.arizona.edu/users/brewerm/");
      $pdf->SetFont('', "");
      $pdf->SetTextColor(0,0,0);
   }
   else
   {
      $pdf->Write($lineHeight,"Unknown ");
      $pdf->SetTextColor(0,0,255);
      $pdf->SetFont('', "U");
      $pdf->Write($lineHeight,"[link to the law]","http://intranet.library.arizona.edu/users/brewerm/");
      $pdf->SetFont('', "");
      $pdf->SetTextColor(0,0,0);
   }
}
else
   $pdf->Write($lineHeight,"N/A");

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Title of Work Used:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["pubTitle"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);


$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Copyright Holder:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["pubAuthor"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Publication Status:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

if(isset($_SESSION["published"]))
{
   if($_SESSION["published"] == "y")
      $pdf->Write($lineHeight,"Published");
   else if($_SESSION["published"] == "n")
      $pdf->Write($lineHeight,"Unpublished");
   else
      $pdf->Write($lineHeight,"Unknown");
}
else
   $pdf->Write($lineHeight,"N/A");


$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Publisher:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["publisher"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Place of Publication:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["pubPlace"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Publication Year:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->SetMargins($col2Start,$pdf->defaultMargin,$pdf->defaultMargin);
$pdf->Write($lineHeight,stripslashes($_SESSION["pubYear"]));
$pdf->SetMargins($pdf->defaultMargin,$pdf->defaultMargin,$pdf->defaultMargin);

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Description of Work:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->MultiCell(0,$lineHeight-4,stripslashes($_SESSION["pubDescription"]));

$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Date of Evaluation:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);
$pdf->Write($lineHeight,date("F j, Y"));

$pdf->Ln();
$pdf->DrawHR(1,false);

$pdf->SetFont('', "B");
$pdf->Write($lineHeight,"Date of Intended Use:");
$pdf->SetFont('', "");
$pdf->SetX($col2Start);

$pdf->Write($lineHeight,date("F j, Y", strtotime("40 days")));

$pdf->SetFillColor(0,0,153);
$pdf->SetDrawColor(0,0,153);

$pdf->DrawHR();

$pageBreak = false;


/*****************************
 *          PURPOSE          *
 *************************************************************************/
if(isset($_SESSION["purpose"]) && !empty($_SESSION["purpose"]))
{
   $lineHeight = 28;

   if(!availableSpace($pdf, $lineHeight, $_SESSION["purpose"]))
      $pdf->AddPage();


   $pdf->SetFont('', "B");

   $pdf->Write($lineHeight,"Describe the  ");
   $pdf->SetFont('', "BU");
   $pdf->SetFontSize(28);
   $pdf->Write($lineHeight,"Purpose");
   $pdf->SetFont('', "B");
   $pdf->SetFontSize(9);
   $pdf->Write($lineHeight,"  and Character of Your Intended Use:");
   $pdf->Ln();
   $pdf->Ln();

   $pdf->SetFont('', "");

   $lineHeight = 11;

   $pdf->SetFillColor(219,229,241);
   $pdf->SetDrawColor(0,0,0);
   $pdf->SetLineWidth(1);
   $pdf->MultiCell(0,$lineHeight,"\n".stripslashes($_SESSION["purpose"])."\n\n",1,"L",1);

   $pdf->DrawFairnessScale($_SESSION["purposeFair"]);

   $pdf->Ln();

}
/****************************
 *          AMOUNT          *
 *************************************************************************/
if(isset($_SESSION["amount"]) && !empty($_SESSION["amount"]))
{
   $lineHeight = 28;

   if(!availableSpace($pdf, $lineHeight, $_SESSION["amount"]))
      $pdf->AddPage();


   $pdf->SetFont('', "B");

   $pdf->Write($lineHeight,"Describe the  ");
   $pdf->SetFont('', "BU");
   $pdf->SetFontSize(28);
   $pdf->Write($lineHeight,"Amount");
   $pdf->SetFont('', "B");
   $pdf->SetFontSize(9);
   $pdf->Write($lineHeight," of Your Intended Use in Relation to the Copyrighted Work as a Whole:");
   $pdf->Ln();
   $pdf->Ln();

   $pdf->SetFont('', "");

   $lineHeight = 11;

   $pdf->SetFillColor(219,229,241);
   $pdf->SetDrawColor(0,0,0);
   $pdf->SetLineWidth(1);
   $pdf->MultiCell(0,$lineHeight,"\n".stripslashes($_SESSION["amount"])."\n\n",1,"L",1);

   $pdf->DrawFairnessScale($_SESSION["amountFair"]);

   $pdf->Ln();

}

/****************************
 *          NATURE          *
 *************************************************************************/
if(isset($_SESSION["nature"]) && !empty($_SESSION["nature"]))
{
   $lineHeight = 28;

   if(!availableSpace($pdf, $lineHeight, $_SESSION["nature"]))
      $pdf->AddPage();


   $pdf->SetFont('', "B");

   $pdf->Write($lineHeight,"Describe the  ");
   $pdf->SetFont('', "BU");
   $pdf->SetFontSize(28);
   $pdf->Write($lineHeight,"Nature");
   $pdf->SetFont('', "B");
   $pdf->SetFontSize(9);
   $pdf->Write($lineHeight," of Your Intended Use:");
   $pdf->Ln();
   $pdf->Ln();

   $pdf->SetFont('', "");

   $lineHeight = 11;

   $pdf->SetFillColor(219,229,241);
   $pdf->SetDrawColor(0,0,0);
   $pdf->SetLineWidth(1);
   $pdf->MultiCell(0,$lineHeight,"\n".stripslashes($_SESSION["nature"])."\n\n",1,"L",1);

   $pdf->DrawFairnessScale($_SESSION["natureFair"]);

   $pdf->Ln();

}

/****************************
 *          EFFECT          *
 *************************************************************************/
if(isset($_SESSION["effect"]) && !empty($_SESSION["effect"]))
{

   if(!availableSpace($pdf, $lineHeight, $_SESSION["effect"]))
      $pdf->AddPage();

   $pdf->SetFont('', "B");

   $pdf->Write($lineHeight,"Describe the  ");
   $pdf->SetFont('', "BU");
   $pdf->SetFontSize(28);
   $pdf->Write($lineHeight,"Effect");
   $pdf->SetFont('', "B");
   $pdf->SetFontSize(9);
   $pdf->Write($lineHeight," of Your Intended Use on the Potential Market or Value of the Copyrighted Work:");
   $pdf->Ln();
   $pdf->Ln();

   $pdf->SetFont('', "");

   $lineHeight = 11;

   $pdf->SetFillColor(219,229,241);
   $pdf->SetDrawColor(0,0,0);
   $pdf->SetLineWidth(1);
   $pdf->MultiCell(0,$lineHeight,"\n".stripslashes($_SESSION["effect"])."\n\n",1,"L",1);

   $pdf->DrawFairnessScale($_SESSION["effectFair"]);

   $pdf->Ln();

}

/*****************************
 *      FAIRNESS LEVEL       *
 *************************************************************************/
$lineHeight = 28;

if(!availableSpace($pdf, $lineHeight, "The Average \"Fairness Level,\" Based on Your Rating of Each of the 4 Factors, Is:"))
   $pdf->AddPage();

$pdf->SetFont('', "B");

$pdf->Write($lineHeight,"The Average ");
$pdf->SetFont('', "BU");
$pdf->SetFontSize(28);
$pdf->Write($lineHeight,"\"Fairness Level,\"");
$pdf->SetFont('', "B");
$pdf->SetFontSize(9);
$pdf->Write($lineHeight," Based on Your Rating of Each of the 4 Factors, Is:");
$pdf->Ln();
$pdf->SetFont('', "");
$lineHeight = 11;

$linkURL = split("/pdf/",$_SERVER["REQUEST_URI"]);
$linkURL = "http://".$_SERVER["HTTP_HOST"].$linkURL[0];
$linkURL = "";

$pdf->SetTextColor(0,0,255);
$pdf->Write($lineHeight,"[see tool disclaimer for important clarifying information]:",$linkURL."../disclaimer.php");
$pdf->SetTextColor(0,0,0);
$pdf->Ln();
$pdf->Ln();
$pdf->DrawFairnessScale(ceil($_SESSION["averageFairness"]));
$pdf->Ln();

/*****************************
 *          OTHER            *
 *************************************************************************/
if(isset($_SESSION["other"]) && !empty($_SESSION["other"]))
{
   $lineHeight = 28;

   if(!availableSpace($pdf, $lineHeight, $_SESSION["other"]))
      $pdf->AddPage();

   $pdf->SetFont('', "BU");
   $pdf->SetFontSize(28);
   $pdf->Write($lineHeight,"Other");
   $pdf->SetFont('', "B");
   $pdf->SetFontSize(9);
   $pdf->Write($lineHeight," Important Criteria:");
   $pdf->Ln();
   $pdf->Ln();

   $pdf->SetFont('', "");

   $lineHeight = 11;

   $pdf->SetFillColor(219,229,241);
   $pdf->SetDrawColor(0,0,0);
   $pdf->SetLineWidth(1);
   if(isset($_SESSION["other"]) && !empty($_SESSION["effect"]))
      $pdf->MultiCell(0,$lineHeight,"\n".$_SESSION["other"]."\n\n",1,"L",1);
   else
      $pdf->MultiCell(0,$lineHeight,"\n"."None Provided"."\n\n",1,"L",1);

   $pdf->Ln();

$pdf->SetFillColor(0,0,153);
$pdf->SetDrawColor(0,0,153);
$pdf->DrawHR();

$pdf->Ln();
}

/*****************************
 *     FINAL PARAGRAPH       *
 *************************************************************************/
$finalText = "Based on the information and justification I have provided above, I, ".
             stripslashes($_SESSION["userName"]).
             ", am asserting this use is: FAIR under Section 107 of the U.S. Copyright Code.";

if(!availableSpace($pdf, $lineHeight, $finalText))
   $pdf->AddPage();

$pdf->Write($lineHeight,"Based on the information and justification I have provided above, I");

if(!empty($_SESSION["userName"]))
   $pdf->Write($lineHeight,", ". stripslashes($_SESSION["userName"]). ",");

if($_SESSION["userFairness"] == "y" || $_SESSION["userFairness"] == "n")
{
   $pdf->Write($lineHeight," am asserting this use is ");

   $pdf->SetTextColor(0,0,255);
   $pdf->SetFont('', "B");
   if($_SESSION["userFairness"] == "y")
      $pdf->Write($lineHeight,"FAIR");
   else
      $pdf->Write($lineHeight,"UNFAIR");
   $pdf->SetFont('', "");
   $pdf->SetTextColor(0,0,0);
}
else
{
   $pdf->Write($lineHeight," am ");

   $pdf->SetTextColor(0,0,255);
   $pdf->SetFont('', "B");
   $pdf->Write($lineHeight,"UNDECIDED");
   $pdf->SetFont('', "");
   $pdf->SetTextColor(0,0,0);

   $pdf->Write($lineHeight," whether this use if fair");

}

$pdf->Write($lineHeight," under Section 107 of the U.S. Copyright Code.");

$pdf->Ln();
$pdf->Ln();

$pdf->SetFillColor(0,0,0);
$pdf->SetDrawColor(0,0,0);

$pdf->SetX($pdf->GetX()+200);

$pdf->Write($lineHeight,"Signature:  ");
$pdf->Line($pdf->GetX(), $pdf->GetY()+12, $pdf->GetX()+200, $pdf->GetY()+12);
$pdf->Ln();
$pdf->Ln();

$pdf->SetX($pdf->GetX()+168);
$pdf->Write($lineHeight,"Date of Signature:  ");
$pdf->Line($pdf->GetX(), $pdf->GetY()+12, $pdf->GetX()+200, $pdf->GetY()+12);

$pdf->Output("Fair Use Evaluation Documentation - ".$_SESSION["pubTitle"].".pdf", "D");



// This function checks to see if there's enough room on the page
// for the section about to be written.
/*********************************************************
 * FUNCTION: availableSpace                              *
 *                                                       *
 * PURPOSE: Checks to see if there is enough room on the *
 *          page for the section about to be written.    *
 *                                                       *
 * PARAMETERS:                                           *
 *     - pdf        - Instance of the PDF object being   *
 *                    used                               *
 *                                                       *
 *     - lineHeight - the line height that will be used  *
 *                    to display the text in question    *
 *                                                       *
 *     - content    - the content being added to the PDF *
 *                                                       *
 * RETURNS: Boolean true or false, depending on if there *
 *          is room for the content on the current page  *
 *          of the PDF.                                  *
 *                                                       *
 *********************************************************/
function availableSpace($pdf, $lineHeight, $content)
{

   // Need to check if we can fit the section on the page.
   $lines = explode("<br>", nl2br($content));
   $linesNeeded = count($lines);

   // Account for padding.
   $linesNeeded+= 3;

   foreach($lines as $line)
   {
      if(!empty($line))
      {
         if(strlen($line) > 100)
            $linesNeeded++;
      }
   }

   if( ($linesNeeded*$lineHeight) > ($pdf->CurPageFormat[1] - ($pdf->bMargin + $pdf->tMargin + $pdf->GetY())))
      return false;
   else
      return true;
}

?>