//will split the Brazilian coins dataset (from Kaggle)
//in traiv/val folders, with one folder per class
//Initially given as filename, value in csv files
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

char IMG_TRAIN_DIR[]= ".\\my_coin_database\\Images\\training\\";
char IMG_VAL_DIR[]= ".\\my_coin_database\\Images\\validation\\";
char TRAIN_CSV[]= ".\\my_coin_database\\Annotations\\training.csv";
char VAL_CSV[]= ".\\my_coin_database\\Annotations\\validation.csv";
#define N_CLASS 5
char TRAIN_TARGET_DIR[]= ".\\train\\";
char VAL_TARGET_DIR[]= ".\\validation\\";
//names for each class directory
char class_dirs[N_CLASS][4]={"005","010","025","050","100"};

int SplitInDirs(char *from, char *csv, char *new_dir);
void init_dirs();
void create_dirs(char *parent);
int main()
{
 FILE *fp;
 int n_img;
 init_dirs(); //crates "description.txt" and all new directories
 fp = fopen("description.txt","a");
 printf("Processing training images from\n%s\n",IMG_TRAIN_DIR);
 n_img = SplitInDirs(IMG_TRAIN_DIR, TRAIN_CSV, TRAIN_TARGET_DIR);
 printf("Splitted %d images in %d class directories\n", n_img, N_CLASS);
 fprintf(fp, "%d train images\n", n_img);
 printf("Processing validation images from\n%s\n",IMG_VAL_DIR);
 n_img = SplitInDirs(IMG_VAL_DIR, VAL_CSV, VAL_TARGET_DIR);
 printf("Splitted %d images in %d class directories\n", n_img, N_CLASS);
 fprintf(fp, "%d validation images\n", n_img);
 fclose(fp);
 printf("Done!\n");
 return 0;
}

//launches dir structure if not ready
void init_dirs()
{ 
 FILE *fp = fopen("description.txt", "r");
 if(fp == NULL){ //nor ready -> init all dirs
  fp = fopen("description.txt", "w");
  fprintf(fp,"Brazilian coins (Kaggle), %d classes\n",N_CLASS);
  create_dirs(TRAIN_TARGET_DIR);
  create_dirs(VAL_TARGET_DIR); 
 }
 fclose(fp);
 printf("Target dirs ready.\n");
}
//creates class directories
void create_dirs(char *parent)
{
 char str[200], command[300];	
 int i;
 sprintf(command, "mkdir %s", parent);
 system(command);
 for (i=0; i<N_CLASS; i++){
  strcpy(str, parent);
  strcat(str, class_dirs[i]);
  sprintf(command, "mkdir %s", str);
  system(command);  
 }
}

int SplitInDirs(char *from, char *csv, char *new_dir)
{
 char str[80], command[400], fname[20];
 char *token;
 int class, i=0; 
 FILE *fp = fopen(csv,"r"); //open for reading
 if(fp==NULL){
	 printf("Cant't open %s\n", csv);
	 return 0;
 }
 fgets(str,80,fp);//discard header
while(!feof(fp)){
  fgets(str,80,fp); //read new line
  //extract file name and class
  token = strtok(str, ","); //split string at ","
  strcpy(fname, token);
  token = strtok(NULL, ",");
  class = atoi(token);
  //printf("File: %s\nClass:%d (%s)\n", fname, class, class_name);
  sprintf(command, "copy %s%s %s%03d\\%s", 
				  from, fname, new_dir, class, fname);
  if(system(command) == -1){
	printf("Command error: %s\n", command);  
	break; //terminate looping, something went wrong!
  }
  i++;
 }//while not feof
 fclose(fp);
 return i;
}